<?php
// app/core/helpers.php

if (!function_exists('e')) {
  function e($v) {
    return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8');
  }
}

/**
 * Monta URL relativa à pasta /public
 * Ex.: url('empresas/novo.php?id=1')
 */
if (!function_exists('url')) {
  function url(string $path = ''): string {
    // base detecta a raiz da pasta "public"
    $scriptDir = rtrim(str_replace('\\','/', dirname($_SERVER['SCRIPT_NAME'])), '/');
    // se acessar subpastas, forçamos que a base seja .../public
    if (substr($scriptDir, -6) !== '/public') {
      // tenta localizar "/public" no caminho
      $pos = strripos($scriptDir, '/public');
      if ($pos !== false) {
        $scriptDir = substr($scriptDir, 0, $pos + 7); // inclui '/public'
      }
    }
    return rtrim($scriptDir, '/') . '/' . ltrim($path, '/');
  }
}

/** Redireciona para uma rota relativa à /public */
if (!function_exists('redirect')) {
  function redirect(string $path): void {
    if (preg_match('#^https?://#i', $path)) {
      header('Location: ' . $path);
      exit;
    }
    header('Location: ' . url($path));
    exit;
  }
}

// helpers/orientacoes.php (ou cole no topo de relatorios/index.php e relatorios/pdf.php)
function orientacoes_concluidas(PDO $pdo, int $execucaoId): bool {
  // total de perguntas RESPONDIDAS (tem linha em respostas com valor em resposta)
  $q1 = $pdo->prepare("
    SELECT COUNT(*) 
      AS c 
      FROM respostas 
     WHERE execucao_id = ? 
       AND resposta IS NOT NULL
  ");
  $q1->execute([$execucaoId]);
  $respondidas = (int)$q1->fetchColumn();

  if ($respondidas === 0) {
    // sem respostas, nada para orientar -> considera NÃO concluído (ajuste se preferir true)
    return false;
  }

  // total de orientações com texto não-vazio para as perguntas respondidas
  $q2 = $pdo->prepare("
    SELECT COUNT(*)
      FROM orientacoes_tecnicas o
      JOIN respostas r 
        ON r.execucao_id = o.execucao_id 
       AND r.pergunta_id = o.pergunta_id
     WHERE r.execucao_id = ?
       AND r.resposta IS NOT NULL
       AND TRIM(COALESCE(o.texto, '')) <> ''
  ");
  $q2->execute([$execucaoId]);
  $orientadas = (int)$q2->fetchColumn();

  return $orientadas === $respondidas;
}

