<?php
// public/checklists/aplicar.php
require_once __DIR__ . '/../../app/core/auth.php';
require_login();

require_once __DIR__ . '/../../app/config/db.php';
require_once __DIR__ . '/../../app/core/helpers.php';
require_once __DIR__ . '/../../app/core/rbac.php';

// Somente empresa_user pode acessar
require_role('empresa_user');

$scope        = current_scope();
$empresaId    = $scope['empresa_id'] ? (int)$scope['empresa_id'] : null;
$colaboradorId= $scope['colaborador_id'] ? (int)$scope['colaborador_id'] : null;

// Se não tiver empresa_id na sessão (pode acontecer), tentamos inferir pela tabela colaboradores
if (!$empresaId && $colaboradorId) {
  $stEmp = $pdo->prepare("SELECT empresa_id FROM colaboradores WHERE id=? LIMIT 1");
  $stEmp->execute([$colaboradorId]);
  $empresaId = (int)($stEmp->fetchColumn() ?: 0);
  if ($empresaId) {
    $_SESSION['user']['empresa_id'] = $empresaId; // hidrata sessão
  }
}

// Guardas de consistência
$pageTitle = 'Aplicar Checklist';
include __DIR__ . '/../../app/partials/head.php';
include __DIR__ . '/../../app/partials/topbar.php';

if (!$colaboradorId) {
  echo "<div class='container mt-4'>
          <div class='alert alert-danger'>
            Seu usuário não está vinculado a um <strong>Colaborador</strong>. 
            Entre em contato com o administrador para ajustar o vínculo e liberar as execuções.
          </div>
        </div>";
  include __DIR__ . '/../../app/partials/foot.php';
  exit;
}

if (!$empresaId) {
  echo "<div class='container mt-4'>
          <div class='alert alert-danger'>
            Não foi possível determinar sua <strong>Empresa</strong>. 
            Entre em contato com o administrador.
          </div>
        </div>";
  include __DIR__ . '/../../app/partials/foot.php';
  exit;
}

/**
 * Listagem de checklists:
 * - Apenas da empresa do usuário
 * - Apenas status 'ativo'
 * - Apenas com ao menos uma pergunta atribuída a este colaborador
 */
$sql = "
SELECT DISTINCT
  c.id,
  c.titulo,
  c.descricao,
  c.status,
  e.razao_social AS empresa_nome,
  -- total de perguntas atribuídas ao colaborador neste checklist
  (SELECT COUNT(*)
     FROM checklist_perguntas p2
     JOIN checklist_pergunta_responsaveis r2 ON r2.pergunta_id = p2.id
    WHERE p2.checklist_id = c.id
      AND r2.colaborador_id = :colabId) AS minhas_perguntas,
  -- total de perguntas do checklist (informativo)
  (SELECT COUNT(*) FROM checklist_perguntas p3 WHERE p3.checklist_id = c.id) AS total_perguntas
FROM checklists c
JOIN empresas e ON e.id = c.empresa_id
JOIN checklist_perguntas p  ON p.checklist_id = c.id
JOIN checklist_pergunta_responsaveis r ON r.pergunta_id = p.id
WHERE c.status = 'ativo'
  AND c.empresa_id = :empresaId
  AND r.colaborador_id = :colabId
ORDER BY c.titulo
";
$st = $pdo->prepare($sql);
$st->execute([':empresaId' => $empresaId, ':colabId' => $colaboradorId]);
$lista = $st->fetchAll();

?>
<div class="container mt-4">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h1 class="h4 m-0">Aplicar Checklist</h1>
    <div class="text-muted">
      Empresa: <strong>
        <?php
          $eNome = $pdo->prepare("SELECT razao_social FROM empresas WHERE id=?");
          $eNome->execute([$empresaId]);
          echo e($eNome->fetchColumn() ?: '—');
        ?>
      </strong>
    </div>
  </div>

  <?php if (!$lista): ?>
    <div class="alert alert-info">
      Não há checklists <strong>ativos</strong> da sua empresa com perguntas atribuídas a você.
      <br>Se isso estiver incorreto, peça para o administrador revisar as atribuições.
    </div>
  <?php else: ?>
    <div class="table-responsive">
      <table class="table table-hover align-middle">
        <thead>
          <tr>
            <th style="width:60px;">#</th>
            <th>Título</th>
            <th>Objetivo</th>
            <th style="width:180px;">Minhas Perguntas</th>
            <th style="width:140px;" class="text-end">Ação</th>
          </tr>
        </thead>
        <tbody>
        <?php foreach ($lista as $i => $c): ?>
          <tr>
            <td><?= (int)($i+1) ?></td>
            <td>
              <div class="fw-semibold"><?= e($c['titulo']) ?></div>
              <div class="small text-muted">Checklist ID: <?= (int)$c['id'] ?></div>
            </td>
            <td><?= nl2br(e($c['descricao'] ?: '—')) ?></td>
            <td>
              <?php
                $mine  = (int)$c['minhas_perguntas'];
                $total = (int)$c['total_perguntas'];
              ?>
              <span class="badge bg-primary"><?= $mine ?></span>
              <span class="text-muted">de</span>
              <span class="badge bg-secondary"><?= $total ?></span>
            </td>
            <td class="text-end">
              <a class="btn btn-sm btn-success"
                 href="<?= e(url('execucoes/nova.php?checklist_id='.(int)$c['id'])) ?>">
                 Iniciar
              </a>
            </td>
          </tr>
        <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  <?php endif; ?>
</div>

<?php include __DIR__ . '/../../app/partials/foot.php'; ?>
