<?php
// public/execucoes/detalhe.php
require_once __DIR__ . '/../../app/core/auth.php';
require_login();
require_once __DIR__ . '/../../app/config/db.php';
require_once __DIR__ . '/../../app/core/helpers.php';

$id=(int)($_GET['id'] ?? 0);
$pageTitle='Detalhe da Execução';
include __DIR__ . '/../../app/partials/head.php';
include __DIR__ . '/../../app/partials/topbar.php';

$st = $pdo->prepare("
  SELECT x.*, e.razao_social, c.titulo
  FROM execucoes x
  JOIN empresas e ON e.id=x.empresa_id
  JOIN checklists c ON c.id=x.checklist_id
  WHERE x.id=?
");
$st->execute([$id]);
$exec = $st->fetch();
if(!$exec){ echo "<div class='alert alert-danger'>Execução não encontrada.</div>"; include __DIR__ . '/../../app/partials/foot.php'; exit; }

/* Buscar perguntas + respostas + pesos + setor/gerência */
$rows = $pdo->prepare("
  SELECT p.id AS pergunta_id, p.texto, p.peso, p.ordem,
         g.nome AS gerencia_nome, s.nome AS setor_nome,
         r.resposta, r.observacao
  FROM checklist_perguntas p
  LEFT JOIN respostas r ON r.pergunta_id=p.id AND r.execucao_id=?
  JOIN gerencias g ON g.id=p.gerencia_id
  JOIN setores s   ON s.id=p.setor_id
  WHERE p.checklist_id=?
  ORDER BY p.ordem, p.id
");
$rows->execute([$id, (int)$exec['checklist_id']]);
$perg = $rows->fetchAll();

/* Fotos por pergunta */
$fotos = [];
if ($perg) {
  $ids = array_column($perg, 'pergunta_id');
  $in  = implode(',', array_fill(0, count($ids), '?'));
  $qf = $pdo->prepare("
    SELECT rf.caminho, rp.pergunta_id
    FROM resposta_fotos rf
    JOIN respostas rp ON rp.id=rf.resposta_id
    WHERE rp.execucao_id=? AND rp.pergunta_id IN ($in)
    ORDER BY rf.id
  ");
  $bind = array_merge([$id], $ids);
  $qf->execute($bind);
  foreach($qf->fetchAll() as $f){
    $p = (int)$f['pergunta_id'];
    $fotos[$p] = $fotos[$p] ?? [];
    $fotos[$p][] = $f['caminho'];
  }
}

/* Cálculo de notas */
$sumPeso = 0; $sumPts = 0;
$porSetor = [];   // setor_nome => [peso, pts]
$porGer   = [];   // gerencia_nome => [peso, pts]

foreach($perg as $p){
  $peso = (float)$p['peso'];
  $val = ($p['resposta']==='conforme') ? 1.0 : (($p['resposta']==='nao_conforme') ? 0.0 : null);
  if ($val !== null) {
    $sumPeso += $peso;
    $sumPts  += $peso * $val;

    $sn = $p['setor_nome']; $gn = $p['gerencia_nome'];
    if (!isset($porSetor[$sn])) $porSetor[$sn] = ['peso'=>0,'pts'=>0];
    if (!isset($porGer[$gn]))   $porGer[$gn]   = ['peso'=>0,'pts'=>0];
    $porSetor[$sn]['peso'] += $peso; $porSetor[$sn]['pts'] += $peso*$val;
    $porGer[$gn]['peso']   += $peso; $porGer[$gn]['pts']   += $peso*$val;
  }
}
$notaGeral = $sumPeso>0 ? round(($sumPts/$sumPeso)*100, 2) : null;
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h1 class="h4 m-0">Execução #<?= (int)$exec['id'] ?></h1>
  <a href="<?= e(url('execucoes/index.php')) ?>" class="btn btn-outline-secondary">Voltar</a>
</div>

<div class="card mb-4">
  <div class="card-body">
    <div><strong>Empresa:</strong> <?= e($exec['razao_social']) ?></div>
    <div><strong>Checklist:</strong> <?= e($exec['titulo']) ?></div>
    <div><strong>Status:</strong> <span class="badge bg-<?= $exec['status']==='finalizado'?'success':($exec['status']==='em_andamento'?'warning text-dark':'secondary') ?>"><?= e($exec['status']) ?></span></div>
    <div><strong>Iniciado:</strong> <?= e($exec['iniciado_em']) ?> | <strong>Finalizado:</strong> <?= e($exec['finalizado_em'] ?? '-') ?></div>
    <div class="mt-2"><strong>Nota Geral:</strong> <?= $notaGeral!==null ? $notaGeral.'%' : '—' ?></div>
  </div>
</div>

<div class="row g-3">
  <div class="col-md-6">
    <div class="card h-100">
      <div class="card-body">
        <h5 class="card-title">Notas por Gerência</h5>
        <ul class="list-group list-group-flush">
          <?php foreach($porGer as $gn=>$v): 
            $nota = $v['peso']>0 ? round(($v['pts']/$v['peso'])*100,2) : null; ?>
            <li class="list-group-item d-flex justify-content-between">
              <span><?= e($gn) ?></span>
              <span><?= $nota!==null ? $nota.'%' : '—' ?></span>
            </li>
          <?php endforeach; if(!$porGer): ?>
            <li class="list-group-item text-muted">Sem dados suficientes.</li>
          <?php endif; ?>
        </ul>
      </div>
    </div>
  </div>
  <div class="col-md-6">
    <div class="card h-100">
      <div class="card-body">
        <h5 class="card-title">Notas por Setor</h5>
        <ul class="list-group list-group-flush">
          <?php foreach($porSetor as $sn=>$v): 
            $nota = $v['peso']>0 ? round(($v['pts']/$v['peso'])*100,2) : null; ?>
            <li class="list-group-item d-flex justify-content-between">
              <span><?= e($sn) ?></span>
              <span><?= $nota!==null ? $nota.'%' : '—' ?></span>
            </li>
          <?php endforeach; if(!$porSetor): ?>
            <li class="list-group-item text-muted">Sem dados suficientes.</li>
          <?php endif; ?>
        </ul>
      </div>
    </div>
  </div>
</div>

<div class="card mt-4">
  <div class="card-body">
    <h5 class="card-title mb-3">Perguntas e Respostas</h5>
    <div class="table-responsive">
      <table class="table table-sm table-striped align-middle">
        <thead><tr>
          <th>#</th><th>Pergunta</th><th>Gerência</th><th>Setor</th><th>Resposta</th><th>Observação</th><th>Fotos</th>
        </tr></thead>
        <tbody>
        <?php foreach($perg as $p):
          $pid=(int)$p['pergunta_id'];
          $fs = $fotos[$pid] ?? [];
        ?>
          <tr>
            <td><?= (int)$p['ordem'] ?></td>
            <td><?= nl2br(e($p['texto'])) ?></td>
            <td><?= e($p['gerencia_nome']) ?></td>
            <td><?= e($p['setor_nome']) ?></td>
            <td>
              <?php if($p['resposta']==='conforme'): ?>
                <span class="badge bg-success">Conforme</span>
              <?php elseif($p['resposta']==='nao_conforme'): ?>
                <span class="badge bg-danger">Não conforme</span>
              <?php else: ?>
                <span class="badge bg-secondary">—</span>
              <?php endif; ?>
            </td>
            <td><?= nl2br(e($p['observacao'] ?? '')) ?></td>
            <td style="min-width:200px">
              <?php foreach($fs as $c): ?>
                <a href="<?= e(url($c)) ?>" target="_blank">
                  <img src="<?= e(url($c)) ?>" alt="foto" style="height:50px; margin-right:6px; border:1px solid #ddd; padding:2px;">
                </a>
              <?php endforeach; ?>
            </td>
          </tr>
        <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>

<?php include __DIR__ . '/../../app/partials/foot.php'; ?>
