<?php
// public/execucoes/index.php
require_once __DIR__ . '/../../app/core/auth.php';
require_login();
require_once __DIR__ . '/../../app/config/db.php';
require_once __DIR__ . '/../../app/core/helpers.php';

$pageTitle='Execuções';
include __DIR__ . '/../../app/partials/head.php';
include __DIR__ . '/../../app/partials/topbar.php';

$empresaId = (int)($_GET['empresa_id'] ?? 0);
$checklistId = (int)($_GET['checklist_id'] ?? 0);
$status = $_GET['status'] ?? '';
$de = $_GET['de'] ?? '';
$ate = $_GET['ate'] ?? '';
$page = max(1,(int)($_GET['p'] ?? 1)); $pp=10; $off=($page-1)*$pp;

$empresas = $pdo->query("SELECT id, razao_social FROM empresas ORDER BY razao_social")->fetchAll();
$checklists = $pdo->query("SELECT id, titulo FROM checklists ORDER BY titulo")->fetchAll();

$params=[]; $where="WHERE 1=1";
if ($empresaId>0){ $where.=" AND x.empresa_id=:e"; $params[':e']=$empresaId; }
if ($checklistId>0){ $where.=" AND x.checklist_id=:c"; $params[':c']=$checklistId; }
if (in_array($status,['em_andamento','finalizado','parcial'])){ $where.=" AND x.status=:s"; $params[':s']=$status; }
if ($de!==''){ $where.=" AND x.iniciado_em>=:de"; $params[':de']=$de.' 00:00:00'; }
if ($ate!==''){ $where.=" AND x.iniciado_em<=:ate"; $params[':ate']=$ate.' 23:59:59'; }

$sqlCount=$pdo->prepare("SELECT COUNT(*) c
  FROM execucoes x $where");
$sqlCount->execute($params);
$rows=(int)$sqlCount->fetch()['c'];

$sql=$pdo->prepare("
  SELECT x.*, e.razao_social, c.titulo
  FROM execucoes x
  JOIN empresas e ON e.id=x.empresa_id
  JOIN checklists c ON c.id=x.checklist_id
  $where
  ORDER BY x.iniciado_em DESC, x.id DESC
  LIMIT $pp OFFSET $off
");
$sql->execute($params);
$data=$sql->fetchAll();
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h1 class="h4 m-0">Execuções</h1>
  <a href="<?= e(url('checklists/aplicar.php')) ?>" class="btn btn-primary">Aplicar checklist</a>
</div>

<form class="row g-2 mb-3">
  <div class="col-12 col-md-3">
    <select name="empresa_id" class="form-select">
      <option value="0">Todas as empresas</option>
      <?php foreach($empresas as $e): ?>
      <option value="<?= (int)$e['id'] ?>" <?= $empresaId==$e['id']?'selected':'' ?>><?= e($e['razao_social']) ?></option>
      <?php endforeach; ?>
    </select>
  </div>
  <div class="col-12 col-md-3">
    <select name="checklist_id" class="form-select">
      <option value="0">Todos os checklists</option>
      <?php foreach($checklists as $c): ?>
      <option value="<?= (int)$c['id'] ?>" <?= $checklistId==$c['id']?'selected':'' ?>><?= e($c['titulo']) ?></option>
      <?php endforeach; ?>
    </select>
  </div>
  <div class="col-6 col-md-2">
    <select name="status" class="form-select">
      <option value="">Status (todos)</option>
      <option value="em_andamento" <?= $status==='em_andamento'?'selected':'' ?>>Em andamento</option>
      <option value="finalizado" <?= $status==='finalizado'?'selected':'' ?>>Finalizado</option>
      <option value="parcial" <?= $status==='parcial'?'selected':'' ?>>Parcial</option>
    </select>
  </div>
  <div class="col-6 col-md-2"><input type="date" name="de" class="form-control" value="<?= e($de) ?>"></div>
  <div class="col-6 col-md-2"><input type="date" name="ate" class="form-control" value="<?= e($ate) ?>"></div>
  <div class="col-12 col-md-2"><button class="btn btn-outline-secondary w-100">Filtrar</button></div>
</form>

<div class="table-responsive">
<table class="table table-striped align-middle">
  <thead><tr>
    <th>ID</th><th>Empresa</th><th>Checklist</th><th>Status</th><th>Iniciado</th><th>Finalizado</th><th></th>
  </tr></thead>
  <tbody>
  <?php foreach($data as $r): ?>
    <tr>
      <td><?= (int)$r['id'] ?></td>
      <td><?= e($r['razao_social']) ?></td>
      <td><?= e($r['titulo']) ?></td>
      <td><span class="badge bg-<?= $r['status']==='finalizado'?'success':($r['status']==='em_andamento'?'warning text-dark':'secondary') ?>"><?= e($r['status']) ?></span></td>
      <td><?= e($r['iniciado_em']) ?></td>
      <td><?= e($r['finalizado_em'] ?? '-') ?></td>
      <td class="text-end">
        <a class="btn btn-sm btn-outline-primary" href="<?= e(url('execucoes/detalhe.php?id='.$r['id'])) ?>">Detalhe</a>
      </td>
    </tr>
  <?php endforeach; ?>
  </tbody>
</table>
</div>

<?php $pages=(int)ceil($rows/$pp); if($pages>1): ?>
<nav><ul class="pagination">
  <?php for($i=1;$i<=$pages;$i++): ?>
  <li class="page-item <?= $i==$page?'active':'' ?>">
    <a class="page-link" href="?p=<?= $i ?>&empresa_id=<?= $empresaId ?>&checklist_id=<?= $checklistId ?>&status=<?= urlencode($status) ?>&de=<?= e($de) ?>&ate=<?= e($ate) ?>"><?= $i ?></a>
  </li>
  <?php endfor; ?>
</ul></nav>
<?php endif; ?>
<?php include __DIR__ . '/../../app/partials/foot.php'; ?>
