<?php
// public/relatorios/pdf.php

// ===== DEBUG (REMOVA EM PRODUÇÃO) =====
ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
error_reporting(E_ALL);
// =====================================

require_once __DIR__ . '/../../app/core/auth.php';
require_login();
require_once __DIR__ . '/../../app/config/db.php';
require_once __DIR__ . '/../../app/core/helpers.php';

$autoload = __DIR__ . '/../../vendor/autoload.php';
if (!file_exists($autoload)) {
  http_response_code(500);
  echo 'Instale dompdf: composer require dompdf/dompdf';
  exit;
}
require_once $autoload;

use Dompdf\Dompdf;
use Dompdf\Options;

$execId = (int)($_GET['execucao_id'] ?? 0);
if ($execId <= 0) { http_response_code(400); echo 'execucao_id inválido.'; exit; }

/* Execução + meta */
$st = $pdo->prepare("
  SELECT e.id, e.checklist_id, e.empresa_id, e.status, e.iniciado_em, e.finalizado_em,
         emp.razao_social AS empresa_nome,
         emp.logo         AS empresa_logo,
         c.titulo         AS checklist_titulo,
         c.descricao      AS checklist_descricao
    FROM execucoes e
    JOIN empresas emp ON emp.id = e.empresa_id
    JOIN checklists c ON c.id   = e.checklist_id
   WHERE e.id = ? LIMIT 1
");
$st->execute([$execId]);
$exec = $st->fetch(PDO::FETCH_ASSOC);
if (!$exec) { http_response_code(404); echo 'Execução não encontrada.'; exit; }

/* ===== BLOQUEIOS: somente após finalização + orientações concluídas ===== */
if (($exec['status'] ?? '') !== 'finalizado') {
  http_response_code(403);
  echo 'PDF indisponível: a execução ainda não foi finalizada.';
  exit;
}
if (!function_exists('orientacoes_concluidas') || !orientacoes_concluidas($pdo, $execId)) {
  http_response_code(403);
  echo 'PDF indisponível: finalize as Orientações técnicas desta execução para liberar o PDF.';
  exit;
}

/* Perguntas + respostas + gerência/setor */
$st = $pdo->prepare("
  SELECT p.id AS pergunta_id, p.texto, p.peso, p.ordem,
         g.nome AS gerencia, s.nome AS setor,
         r.id AS resposta_id, r.resposta, r.observacao
    FROM checklist_perguntas p
    JOIN respostas r       ON r.pergunta_id = p.id
    LEFT JOIN gerencias g  ON g.id = p.gerencia_id
    LEFT JOIN setores   s  ON s.id = p.setor_id
   WHERE r.execucao_id = ?
   ORDER BY g.nome, s.nome, p.ordem, p.id
");
$st->execute([$execId]);
$rows = $st->fetchAll(PDO::FETCH_ASSOC);

/* Fotos por resposta */
$fotosByResp = [];
if ($rows) {
  $respIds = array_values(array_filter(array_map('intval', array_column($rows, 'resposta_id'))));
  if ($respIds) {
    $in = implode(',', array_fill(0, count($respIds), '?'));
    $sf = $pdo->prepare("SELECT resposta_id, caminho FROM resposta_fotos WHERE resposta_id IN ($in) ORDER BY id");
    $sf->execute($respIds);
    while ($f = $sf->fetch(PDO::FETCH_ASSOC)) {
      $fotosByResp[(int)$f['resposta_id']][] = $f['caminho'];
    }
  }
}

/* Pivot pergunta->colaboradores */
$collabsByPergunta = [];
if ($rows) {
  $pergIds = array_values(array_filter(array_map('intval', array_column($rows, 'pergunta_id'))));
  if ($pergIds) {
    $in = implode(',', array_fill(0, count($pergIds), '?'));
    $qp = $pdo->prepare("
      SELECT cpr.pergunta_id, c.id AS colaborador_id, c.nome, c.cargo
        FROM checklist_pergunta_responsaveis cpr
        JOIN colaboradores c ON c.id = cpr.colaborador_id
       WHERE cpr.pergunta_id IN ($in)
       ORDER BY c.nome
    ");
    $qp->execute($pergIds);
    while ($r = $qp->fetch(PDO::FETCH_ASSOC)) {
      $collabsByPergunta[(int)$r['pergunta_id']][] = [
        'id'    => (int)$r['colaborador_id'],
        'nome'  => $r['nome'],
        'cargo' => $r['cargo'] ?? ''
      ];
    }
  }
}

/* ========= Orientações técnicas por pergunta (robusto a variações) ========= */
function load_orientacoes_execucao(PDO $pdo, int $execId, array $rows): array {
  $out = [];

  // 1) execucao_orientacoes(execucao_id, pergunta_id, texto)
  try {
    $st = $pdo->prepare("
      SELECT pergunta_id, texto
        FROM execucao_orientacoes
       WHERE execucao_id = ?
       ORDER BY id
    ");
    $st->execute([$execId]);
    $found = false;
    while ($r = $st->fetch(PDO::FETCH_ASSOC)) {
      $pid = (int)($r['pergunta_id'] ?? 0);
      $txt = trim((string)($r['texto'] ?? ''));
      if ($pid > 0 && $txt !== '') { $out[$pid][] = $txt; $found = true; }
    }
    if ($found) return $out;
  } catch (\Throwable $e) {}

  // 2) orientacoes_tecnicas(execucao_id, pergunta_id, texto)
  try {
    $st = $pdo->prepare("
      SELECT pergunta_id, texto
        FROM orientacoes_tecnicas
       WHERE execucao_id = ?
       ORDER BY id
    ");
    $st->execute([$execId]);
    $found = false;
    while ($r = $st->fetch(PDO::FETCH_ASSOC)) {
      $pid = (int)($r['pergunta_id'] ?? 0);
      $txt = trim((string)($r['texto'] ?? ''));
      if ($pid > 0 && $txt !== '') { $out[$pid][] = $txt; $found = true; }
    }
    if ($found) return $out;
  } catch (\Throwable $e) {}

  // 3) resposta_orientacoes(resposta_id, texto) -> mapeia para pergunta_id
  $mapRespToPerg = [];
  foreach ($rows as $r) {
    $rid = (int)$r['resposta_id'];
    $pid = (int)$r['pergunta_id'];
    if ($rid > 0 && $pid > 0) $mapRespToPerg[$rid] = $pid;
  }
  if ($mapRespToPerg) {
    try {
      $respIds = array_keys($mapRespToPerg);
      $in = implode(',', array_fill(0, count($respIds), '?'));
      $st = $pdo->prepare("
        SELECT resposta_id, texto
          FROM resposta_orientacoes
         WHERE resposta_id IN ($in)
         ORDER BY id
      ");
      $st->execute($respIds);
      $found = false;
      while ($r = $st->fetch(PDO::FETCH_ASSOC)) {
        $rid = (int)($r['resposta_id'] ?? 0);
        $txt = trim((string)($r['texto'] ?? ''));
        if ($rid > 0 && isset($mapRespToPerg[$rid]) && $txt !== '') {
          $pid = $mapRespToPerg[$rid];
          $out[$pid][] = $txt;
          $found = true;
        }
      }
      if ($found) return $out;
    } catch (\Throwable $e) {}
  }

  return $out;
}

$orientByPergunta = load_orientacoes_execucao($pdo, $execId, $rows);

/* Notas */
$sumP=0; $sumV=0; $gerScores=[];
foreach ($rows as $r) {
  $peso = (float)$r['peso'];
  $val  = $r['resposta']==='conforme' ? 1 : ($r['resposta']==='nao_conforme' ? 0 : null);
  if ($val===null) continue;
  $sumP += $peso; $sumV += $peso*$val;
  $g = $r['gerencia'] ?: '—';
  if (!isset($gerScores[$g])) $gerScores[$g] = ['peso'=>0,'v'=>0];
  $gerScores[$g]['peso'] += $peso; $gerScores[$g]['v'] += $peso*$val;
}
$notaGeral = $sumP>0 ? round(($sumV/$sumP)*100, 2) : 0;
$notaGer = [];
foreach ($gerScores as $g=>$v) $notaGer[$g] = $v['peso']>0 ? round(($v['v']/$v['peso'])*100, 2) : null;

/* Agrupar por gerência/setor */
$grouped = [];
foreach ($rows as $r) {
  $g = $r['gerencia'] ?: '—';
  $s = $r['setor']    ?: '—';
  $grouped[$g][$s][] = $r;
}

/* Cabeçalho */
$empresaNome   = $exec['empresa_nome'] ?: '—';
$tituloChk     = $exec['checklist_titulo'] ?: 'Checklist';
$descricaoChk  = trim((string)($exec['checklist_descricao'] ?? ''));
$dtVistoria    = $exec['finalizado_em'] ? date('d/m/Y', strtotime($exec['finalizado_em'])) : date('d/m/Y');

/* Placeholders */
$codigo   = '—';
$revisao  = '—';
$unidade  = '—';

$notaPercent = max(0, min(100, (int)round($notaGeral)));

/* ===== LOGO (fora de /public): /zyra-public/uploads/empresas/{id}/logo/ ===== */
$logoData = '';
try {
  $empresaId = (int)($exec['empresa_id'] ?? 0);
  $arquivoDB = trim((string)($exec['empresa_logo'] ?? ''));
  if ($arquivoDB !== '') $arquivoDB = basename($arquivoDB);

  $baseRoot = realpath(__DIR__ . '/../../'); // /zyra-public
  if ($baseRoot === false) { $baseRoot = dirname(dirname(__DIR__)); }

  $dirLogo = $baseRoot . '/uploads/empresas/' . $empresaId . '/logo';

  $logoAbs = null;
  if ($arquivoDB !== '') {
    $caminho = $dirLogo . '/' . $arquivoDB;
    if (is_file($caminho)) $logoAbs = $caminho;
  }
  if (!$logoAbs && is_dir($dirLogo)) {
    $cands = glob($dirLogo . '/*.{png,jpg,jpeg}', GLOB_BRACE);
    if ($cands && isset($cands[0]) && is_file($cands[0])) $logoAbs = $cands[0];
  }
  if (!$logoAbs) {
    $fallback = __DIR__ . '/img/logo_relatorio.png';
    if (is_file($fallback)) $logoAbs = $fallback;
  }
  if ($logoAbs) {
    $ext  = strtolower(pathinfo($logoAbs, PATHINFO_EXTENSION));
    $mime = ($ext === 'jpg') ? 'jpeg' : $ext;
    $logoData = 'data:image/' . $mime . ';base64,' . base64_encode(@file_get_contents($logoAbs));
  }
} catch (\Throwable $e) {
  $logoData = '';
}

ob_start();
?>
<!doctype html>
<html lang="pt-br">
<head>
<meta charset="utf-8">
<style>
  @page { margin: 24px 24px 40px 24px; }
  body { font-family: DejaVu Sans, Arial, Helvetica, sans-serif; font-size: 11px; color: #1a1a1a; }
  .row{ display:flex; flex-wrap:nowrap; align-items:stretch; }
  .col-logo{ width:25%; display:flex; align-items:center; }
  .col-title{ width:50%; text-align:center; display:flex; flex-direction:column; justify-content:center; }
  .col-meta{ width:25%; }
  .muted{ color:#666; } .bold{ font-weight:700; }
  .title { font-size:14px; font-weight:700; text-transform:uppercase; }
  .logo { height:52px; }
  .mini-meta { font-size:10px; border:1px solid #cfd4da; border-radius:6px; padding:6px; display:block; text-align:left; }
  .mini-meta div{ line-height:1.5; }

  .objetivo { margin:10px 0; }
  .obj-label { font-weight:700; margin-bottom:4px; }
  .obj-body  { border:1px solid #cfd4da; border-radius:6px; padding:10px; }

  .score-wrap { margin:12px 0; }
  .q-table { width:100%; border-collapse:collapse; margin-top:6px; }
  .q-table th, .q-table td { border:1px solid #cfd4da; padding:6px; vertical-align:top; }
  .q-table th { background:#f9fafb; text-align:left; font-size:10px; }
  .badge { display:inline-block; padding:2px 8px; border-radius:20px; font-size:10px; font-weight:700; color:#fff; }
  .b-ok{ background:#3aaa35; } .b-nok{ background:#c0392b; }
  .block { margin-top:6px; }
  .block .label { font-weight:700; margin-bottom:3px; }
  .block .body  { border:1px solid #cfd4da; border-radius:6px; padding:8px; }
  .fotos { margin-top:4px; }
  .foto { display:inline-block; width:31.5%; height:90px; border:1px solid #cfd4da; margin:1%; background:#f1f1f1; }
  .foto img { width:100%; height:90px; object-fit:cover; }
  .collab-table { width:100%; border-collapse:collapse; margin-top:10px; }
  .collab-table th, .collab-table td { border:1px solid #cfd4da; padding:6px; }
  .collab-table th { background:#f3f5f7; text-align:left; }
  .collab-title { font-weight:700; margin-top:10px; margin-bottom:4px; }
</style>
</head>
<body>

<table class="q-table" width="100%" cellpadding="0" cellspacing="0" style="margin-bottom:8px; border-collapse:collapse;">
  <tr>
    <td style="width:25%; vertical-align:middle;">
      <div style="text-align:center; margin-bottom:10px;">
        <?php if ($logoData): ?>
          <img src="<?= $logoData ?>" alt="logo" style="height:100px; display:block; margin:0 auto;">
        <?php endif; ?>
      </div>
    </td>
    <td style="width:50%; text-align:center; vertical-align:middle;" >
      <div style="font-size:14px; font-weight:700; text-transform:uppercase;">
        <?= e($tituloChk) ?>
      </div>
    </td>
    <td style="width:25%; vertical-align:middle;">
      <table width="100%" cellpadding="4" cellspacing="0" style="border:1px solid #cfd4da; border-radius:6px;">
        <tr><td style="font-size:10px;"><strong>Código:</strong> —</td></tr>
        <tr><td style="font-size:10px;"><strong>Revisão:</strong> —</td></tr>
        <tr><td style="font-size:10px;"><strong>Unidade:</strong> —</td></tr>
        <tr><td style="font-size:10px;"><strong>Data Vistoria:</strong> <?= e($dtVistoria) ?></td></tr>
      </table>
    </td>
  </tr>
</table>

<div class="objetivo">
  <div class="obj-label">Objetivo:</div>
  <div class="obj-body">
    <?= $descricaoChk !== '' ? nl2br(e($descricaoChk)) :
      'Relatório técnico elaborado a partir de auditoria ambiental realizada na unidade, com o objetivo de avaliar as condições operacionais,
    identificar eventuais deficiências e registrar situações conformes e não conformes observadas nos setores vistoriados.' ?>
  </div>
</div>

<div class="score-wrap">
  <table class="q-table"><tbody>
    <tr>
      <td style="text-align:center">PONTUAÇÃO GERAL DO EMPREENDIMENTO</td>
      <td style="text-align:center"><?= e(number_format($notaGeral, 2, ',', '')) ?>%</td>
    </tr>
  </tbody></table>
</div>

<?php foreach ($grouped as $gerencia => $bySetor): ?>
  <?php $notaG = $notaGer[$gerencia] ?? null; ?>
  <div style="margin-top:12px;">
    <div style="background:#0B3040;color:#fff;padding:7px 10px;border-radius:6px 6px 0 0;display:flex;justify-content:space-between;">
      <div>GERÊNCIA RESPONSÁVEL: <?= e($gerencia) ?></div>
      <div>Pontuação: <?= $notaG !== null ? e(number_format($notaG,2,',','')) . '%' : '—' ?></div>
    </div>
    <div style="border:1px solid #cfd4da;border-top:none;border-radius:0 0 6px 6px;padding:8px 10px;">
      <?php foreach ($bySetor as $setor => $pergList): ?>
        <div style="background:#F1A983;color:#0B3040;padding:6px 10px;border-radius:6px;margin:8px 0 6px 0;font-weight:700;">SETOR: <?= e($setor) ?></div>

        <?php foreach ($pergList as $row): ?>
          <?php
            $ok    = ($row['resposta'] === 'conforme');
            $badge = $ok ? 'background:#3aaa35;color:#fff' : 'background:#c0392b;color:#fff';
            $txtB  = $ok ? 'CONFORME' : 'NÃO CONFORME';
            $respId= (int)$row['resposta_id'];
            $fotos = $fotosByResp[$respId] ?? [];
            $pId   = (int)$row['pergunta_id'];
            $respNames = '—';
            if (!empty($collabsByPergunta[$pId])) {
              $respNames = implode(', ', array_map(function($c){
                return trim((string)($c['cargo'] ?? '—'));
              }, $collabsByPergunta[$pId]));
            }

            // Orientações da pergunta nesta execução
            $orientacoes = $orientByPergunta[$pId] ?? [];
            $orientHtml = '—';
            if (!empty($orientacoes)) {
              $orientacoes = array_values(array_filter(array_map('trim', $orientacoes), fn($t)=>$t!==''));
              if (count($orientacoes) === 1) {
                $orientHtml = nl2br(e($orientacoes[0]));
              } elseif (count($orientacoes) > 1) {
                $items = array_map(fn($t) => '• '.nl2br(e($t)), $orientacoes);
                $orientHtml = implode('<br>', $items);
              }
            }
          ?>
          <table class="q-table">
            <thead>
              <tr>
                <th style="width:70%;">Questão / Tema</th>
                <th style="width:15%;">Responsável no setor</th>
                <th style="width:15%;">Conforme / Não Conforme</th>
              </tr>
            </thead>
            <tbody>
              <tr>
                <td><?= nl2br(e($row['texto'])) ?></td>
                <td><?= e($respNames) ?></td>
                <td><span style="display:inline-block;padding:2px 8px;border-radius:20px;font-size:10px;font-weight:700;<?= $badge ?>"><?= $txtB ?></span></td>
              </tr>
            </tbody>
          </table>

          <div class="block">
            <div class="label">Relato Descritivo do Técnico:</div>
            <div class="body"><?= nl2br(e($row['observacao'] ?: '—')) ?></div>
          </div>

          <div class="block">
            <div class="label">Evidências/Registros Fotográficos:</div>
            <div class="body">
              <?php if ($fotos): ?>
                <div class="fotos">
                  <?php foreach ($fotos as $fp):
                    $abs = realpath(__DIR__ . '/../../' . $fp);
                    $src = ($abs && is_file($abs)) ? 'data:image/jpeg;base64,'.base64_encode(@file_get_contents($abs)) : '';
                  ?>
                    <span class="foto"><?php if ($src): ?><img src="<?= $src ?>" alt="foto"><?php endif; ?></span>
                  <?php endforeach; ?>
                </div>
              <?php else: ?>
                <span class="muted">—</span>
              <?php endif; ?>
            </div>
          </div>

          <div class="block">
            <div class="label">Orientação/Recomendação Técnica:</div>
            <div class="body"><?= $orientHtml ?></div>
          </div>
        <?php endforeach; ?>
      <?php endforeach; ?>

      <?php
        $collabScores = [];
        foreach ($bySetor as $pergList2) {
          foreach ($pergList2 as $r) {
            $peso = (float)$r['peso'];
            $val  = $r['resposta'] === 'conforme' ? 1 : ($r['resposta'] === 'nao_conforme' ? 0 : null);
            if ($val === null || $peso <= 0) continue;
            $pId2 = (int)$r['pergunta_id'];
            $colabs = $collabsByPergunta[$pId2] ?? [];
            if (!$colabs) continue;
            foreach ($colabs as $c) {
              $cid = (int)$c['id'];
              if (!isset($collabScores[$cid])) {
                $collabScores[$cid] = ['nome'=>$c['nome'], 'cargo'=>$c['cargo'] ?? '', 'w'=>0, 'v'=>0];
              } else {
                if ($collabScores[$cid]['cargo']==='' && !empty($c['cargo'])) {
                  $collabScores[$cid]['cargo'] = $c['cargo'];
                }
              }
              $collabScores[$cid]['w'] += $peso;
              $collabScores[$cid]['v'] += $peso * $val;
            }
          }
        }

        if ($collabScores):
      ?>
        <div class="collab-title">Pontuação dos Colaboradores (Gerência: <?= e($gerencia) ?>)</div>
        <table class="collab-table">
          <thead><tr><th style="width:70%;">Colaborador</th><th style="width:30%;">Pontuação</th></tr></thead>
          <tbody>
            <?php foreach ($collabScores as $c): $notaC = $c['w'] > 0 ? round(($c['v'] / $c['w']) * 100, 2) : null; ?>
              <tr>
                <td><?= e($c['cargo'] !== '' ? $c['cargo'] : '—') ?></td>
                <td><?= $notaC !== null ? e(number_format($notaC, 2, ',', '')) . '%' : '—' ?></td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      <?php endif; ?>

    </div>
  </div>
<?php endforeach; ?>

</body>
</html>
<?php
$html = ob_get_clean();

$options = new Options();
$options->set('isRemoteEnabled', true);
$options->set('chroot', realpath(__DIR__ . '/../')); // /zyra-public/public
$dompdf = new Dompdf($options);
$dompdf->loadHtml($html);
$dompdf->setPaper('A4', 'portrait');
$dompdf->render();
$dompdf->stream('relatorio_execucao_'.$execId.'.pdf', ['Attachment' => false]);
