<?php
if (!isset($_SESSION)) session_start();
require_once __DIR__ . '/../core/rbac.php';
require_once __DIR__ . '/../core/helpers.php';

$role = current_role();
?>
<nav class="navbar navbar-expand-lg navbar-dark bg-dark">
  <div class="container-fluid">
    <!-- Logo / Nome -->
    <a class="navbar-brand fw-bold" 
    <?php if ($role === 'empresa_user'): ?>
      href="<?= e(url('empresa_user/index.php')) ?>">
    <?php endif; ?>
    <?php if ($role === 'diretor'): ?>
      href="<?= e(url('diretor/index.php')) ?>">
    <?php endif; ?>
    <?php if ($role === 'gerente'): ?>
      href="<?= e(url('gerencias/index.php')) ?>">
    <?php endif; ?>
     <?php if ($role === 'admin'): ?>
      href="<?= e(url('index.php')) ?>">
    <?php endif; ?>
      📋 Checklist
    </a>

    <!-- Botão hamburguer (mobile) -->
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#mainNavbar" aria-controls="mainNavbar" aria-expanded="false" aria-label="Menu">
      <span class="navbar-toggler-icon"></span>
    </button>

    <!-- Menu -->
    <div class="collapse navbar-collapse" id="mainNavbar">
      <ul class="navbar-nav me-auto mb-2 mb-lg-0">

        <?php if ($role === 'admin'): ?>
          <li class="nav-item"><a class="nav-link" href="<?= e(url('index.php')) ?>">Início</a></li>
          <li class="nav-item dropdown">
            <a class="nav-link dropdown-toggle" href="#" id="navEmpresas" role="button" data-bs-toggle="dropdown" aria-expanded="false">
              Cadastro
            </a>
            <ul class="dropdown-menu" aria-labelledby="navEmpresas">
              <li><a class="dropdown-item" href="<?= e(url('empresas/index.php')) ?>">+ Empresas</a></li>
              <li><a class="dropdown-item" href="<?= e(url('gerencias/index.php')) ?>">+ Gerências</a></li>
              <li><a class="dropdown-item" href="<?= e(url('setores/index.php')) ?>">+ Setores</a></li>
              <li><a class="dropdown-item" href="<?= e(url('colaboradores/index.php')) ?>">+ Colaboradores</a></li>
            </ul>
          </li>
          <li class="nav-item"><a class="nav-link" href="<?= e(url('checklists/index.php')) ?>">Checklists</a></li>
          <li class="nav-item"><a class="nav-link" href="<?= e(url('relatorios/index.php')) ?>">Relatórios</a></li>
          <li class="nav-item"><a class="nav-link" href="<?= e(url('comparador/index.php')) ?>">Comparador</a></li>
        <?php endif; ?>

        <?php if ($role === 'gerente' || $role === 'diretor'): ?>
          <li class="nav-item"><a class="nav-link" href="<?= e(url('relatorios/consolidado.php')) ?>">Relatórios</a></li>
        <?php endif; ?>

        <?php if ($role === 'empresa_user'): ?>
          <li class="nav-item"><a class="nav-link" href="<?= e(url('empresa_user/index.php')) ?>">Minhas Execuções</a></li>
        <?php endif; ?>
      </ul>

      <!-- Usuário logado -->
      <ul class="navbar-nav mb-2 mb-lg-0">
        <?php if (isset($_SESSION['user'])): ?>
          <li class="nav-item dropdown">
            <a class="nav-link dropdown-toggle" href="#" id="userDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
              👤 <?= e($_SESSION['user']['nome']) ?>
            </a>
            <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="userDropdown">
              <li><span class="dropdown-item-text text-muted">Perfil: <?= e($role) ?></span></li>
              <li><hr class="dropdown-divider"></li>
              <li><a class="dropdown-item" href="<?= e(url('auth/logout.php')) ?>">Sair</a></li>
            </ul>
          </li>
        <?php else: ?>
          <li class="nav-item"><a class="nav-link" href="<?= e(url('auth/login.php')) ?>">Entrar</a></li>
        <?php endif; ?>
      </ul>
    </div>
  </div>
</nav>
<div class="container my-4">
