<?php
// public/colaboradores/editar.php
require_once __DIR__ . '/../../app/core/auth.php';
require_login();

require_once __DIR__ . '/../../app/core/rbac.php';
require_role('admin'); // 🔒 somente admin

require_once __DIR__ . '/../../app/config/db.php';
require_once __DIR__ . '/../../app/core/helpers.php';

$pageTitle = 'Editar Colaborador';
include __DIR__ . '/../../app/partials/head.php';
include __DIR__ . '/../../app/partials/topbar.php';

/* ---------- Carrega registro ---------- */
$id = (int)($_GET['id'] ?? 0);
$st = $pdo->prepare("SELECT * FROM colaboradores WHERE id=?");
$st->execute([$id]);
$r = $st->fetch();
if (!$r) {
  echo "<div class='container mt-3'><div class='alert alert-danger'>Registro não encontrado.</div></div>";
  include __DIR__ . '/../../app/partials/foot.php';
  exit;
}

/* Empresas ativas */
$empresas = $pdo->query("
  SELECT id, razao_social
    FROM empresas
   WHERE status='ativo'
   ORDER BY razao_social
")->fetchAll();

/* Estado do form / erros */
$errors = [];
$old = [
  'empresa_id' => $_POST['empresa_id'] ?? $r['empresa_id'],
  'nome'       => $_POST['nome']       ?? $r['nome'],
  'cargo'      => $_POST['cargo']      ?? $r['cargo'],
  'email'      => $_POST['email']      ?? $r['email'],
  'status'     => $_POST['status']     ?? $r['status'],
];

/* ---------- POST ---------- */
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $empresa_id = (int)($old['empresa_id']);
  $nome       = trim((string)$old['nome']);
  $cargo      = trim((string)$old['cargo']);
  $email      = trim((string)$old['email']);
  $status     = ($old['status'] === 'inativo') ? 'inativo' : 'ativo';

  // Empresa válida?
  if ($empresa_id <= 0) {
    $errors[] = 'Selecione uma empresa válida.';
  } else {
    $chkEmp = $pdo->prepare("SELECT COUNT(*) FROM empresas WHERE id=? AND status='ativo'");
    $chkEmp->execute([$empresa_id]);
    if (!(int)$chkEmp->fetchColumn()) {
      $errors[] = 'Empresa inválida ou inativa.';
    }
  }

  // Nome obrigatório
  if ($nome === '') {
    $errors[] = 'Nome é obrigatório.';
  }

  // E-mail (opcional): se preenchido, valida formato e unicidade por empresa
  if ($email !== '') {
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
      $errors[] = 'E-mail inválido.';
    } else {
      $chkMail = $pdo->prepare("
        SELECT COUNT(*) FROM colaboradores
         WHERE email = ? AND empresa_id = ? AND id <> ?
      ");
      $chkMail->execute([$email, $empresa_id, $id]);
      if ((int)$chkMail->fetchColumn() > 0) {
        $errors[] = 'Já existe um colaborador com este e-mail nesta empresa.';
      }
    }
  } else {
    // normaliza vazio para NULL
    $email = null;
  }

  if (!$errors) {
    $up = $pdo->prepare("
      UPDATE colaboradores
         SET empresa_id = ?, nome = ?, cargo = ?, email = ?, status = ?
       WHERE id = ?
    ");
    $ok = $up->execute([$empresa_id, $nome, ($cargo !== '' ? $cargo : null), $email, $status, $id]);
    if ($ok) {
      redirect('colaboradores/index.php');
    } else {
      $errors[] = 'Não foi possível salvar o colaborador.';
    }
  }
}
?>

<div class="d-flex justify-content-between align-items-center mb-3">
  <h1 class="h4 m-0">Editar colaborador</h1>
  <a href="<?= e(url('colaboradores/index.php')) ?>" class="btn btn-outline-secondary">Voltar</a>
</div>

<?php if ($errors): ?>
  <div class="alert alert-danger">
    <strong>Não foi possível salvar:</strong><br>
    <?= implode('<br>', array_map('e', $errors)) ?>
  </div>
<?php endif; ?>

<div class="card">
  <div class="card-body">
    <form method="post" class="row g-3">
      <div class="col-12 col-md-6">
        <label class="form-label">Empresa</label>
        <select name="empresa_id" class="form-select" required>
          <?php foreach ($empresas as $e): ?>
            <option value="<?= (int)$e['id'] ?>" <?= ((string)$old['empresa_id'] === (string)$e['id'] ? 'selected' : '') ?>>
              <?= e($e['razao_social']) ?>
            </option>
          <?php endforeach; ?>
        </select>
      </div>

      <div class="col-12 col-md-6">
        <label class="form-label">Status</label>
        <select name="status" class="form-select">
          <option value="ativo"   <?= $old['status'] === 'ativo'   ? 'selected' : '' ?>>Ativo</option>
          <option value="inativo" <?= $old['status'] === 'inativo' ? 'selected' : '' ?>>Inativo</option>
        </select>
      </div>

      <div class="col-12 col-md-6">
        <label class="form-label">Nome</label>
        <input name="nome" class="form-control" required value="<?= e($old['nome']) ?>">
      </div>

      <div class="col-12 col-md-6">
        <label class="form-label">Cargo <span class="text-muted">(opcional)</span></label>
        <input name="cargo" class="form-control" value="<?= e($old['cargo']) ?>">
      </div>

      <div class="col-12 col-md-6">
        <label class="form-label">E-mail <span class="text-muted">(opcional)</span></label>
        <input type="email" name="email" class="form-control" value="<?= e($old['email']) ?>">
      </div>

      <div class="col-12">
        <button class="btn btn-primary">Salvar</button>
        <a href="<?= e(url('colaboradores/index.php')) ?>" class="btn btn-outline-secondary">Cancelar</a>
      </div>
    </form>
  </div>
</div>

<?php include __DIR__ . '/../../app/partials/foot.php'; ?>
