<?php
// public/colaboradores/index.php
require_once __DIR__ . '/../../app/core/auth.php';
require_login();

require_once __DIR__ . '/../../app/core/rbac.php';
require_role(['admin']); // 🔒 apenas admin

require_once __DIR__ . '/../../app/config/db.php';
require_once __DIR__ . '/../../app/core/helpers.php';

$pageTitle = 'Colaboradores';

$q         = trim($_GET['q'] ?? '');
$empresaId = (int)($_GET['empresa_id'] ?? 0);
$status    = $_GET['status'] ?? '';
$page      = max(1, (int)($_GET['p'] ?? 1));
$pp        = 10;
$off       = ($page - 1) * $pp;

/* Inativar (POST) */
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['inativar_id'])) {
  $id = (int)$_POST['inativar_id'];
  $st = $pdo->prepare("UPDATE colaboradores SET status='inativo' WHERE id=?");
  $st->execute([$id]);
  header("Location: ".url('colaboradores/index.php'));
  exit;
}

/* Empresas ativas para filtro */
$empresas = $pdo->query("
  SELECT id, razao_social
    FROM empresas
   WHERE status='ativo'
   ORDER BY razao_social
")->fetchAll();

/* Monta WHERE dinâmico */
$params = [];
$where  = "WHERE 1=1";
if ($q !== '') {
  $where .= " AND (c.nome LIKE :q OR c.cargo LIKE :q OR c.email LIKE :q)";
  $params[':q'] = "%{$q}%";
}
if ($empresaId > 0) {
  $where .= " AND c.empresa_id = :e";
  $params[':e'] = $empresaId;
}
if ($status === 'ativo' || $status === 'inativo') {
  $where .= " AND c.status = :s";
  $params[':s'] = $status;
}

/* Contagem + listagem */
$sqlCount = $pdo->prepare("SELECT COUNT(*) c FROM colaboradores c $where");
$sqlCount->execute($params);
$rows = (int)$sqlCount->fetch()['c'];

$sql = $pdo->prepare("
  SELECT c.*, e.razao_social
    FROM colaboradores c
    JOIN empresas e ON e.id = c.empresa_id
    $where
   ORDER BY c.criado_em DESC, c.id DESC
   LIMIT $pp OFFSET $off
");
$sql->execute($params);
$data = $sql->fetchAll();

/* View */
include __DIR__ . '/../../app/partials/head.php';
include __DIR__ . '/../../app/partials/topbar.php';
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h1 class="h4 m-0">Colaboradores</h1>
  <a href="<?= e(url('colaboradores/novo.php')) ?>" class="btn btn-primary">Novo colaborador</a>
</div>

<form class="row g-2 mb-3">
  <div class="col-12 col-md-3">
    <input type="text" name="q" class="form-control" placeholder="Buscar por nome/cargo/e-mail" value="<?= e($q) ?>">
  </div>
  <div class="col-12 col-md-4">
    <select name="empresa_id" class="form-select">
      <option value="0">Todas as empresas</option>
      <?php foreach ($empresas as $e): ?>
        <option value="<?= (int)$e['id'] ?>" <?= $empresaId==$e['id']?'selected':'' ?>>
          <?= e($e['razao_social']) ?>
        </option>
      <?php endforeach; ?>
    </select>
  </div>
  <div class="col-6 col-md-2">
    <select name="status" class="form-select">
      <option value="">Status (todos)</option>
      <option value="ativo"   <?= $status==='ativo'?'selected':'' ?>>Ativo</option>
      <option value="inativo" <?= $status==='inativo'?'selected':'' ?>>Inativo</option>
    </select>
  </div>
  <div class="col-6 col-md-3">
    <button class="btn btn-outline-secondary">Filtrar</button>
    <a class="btn btn-link" href="<?= e(url('colaboradores/index.php')) ?>">Limpar</a>
  </div>
</form>

<div class="table-responsive">
  <table class="table table-striped align-middle">
    <thead>
      <tr>
        <th>ID</th>
        <th>Empresa</th>
        <th>Nome</th>
        <th>Cargo</th>
        <th>E-mail</th>
        <th>Status</th>
        <th></th>
      </tr>
    </thead>
    <tbody>
      <?php if (!$data): ?>
        <tr><td colspan="7" class="text-muted">Nenhum colaborador encontrado.</td></tr>
      <?php else: ?>
        <?php foreach ($data as $r): ?>
          <tr>
            <td><?= (int)$r['id'] ?></td>
            <td><?= e($r['razao_social']) ?></td>
            <td><?= e($r['nome']) ?></td>
            <td><?= e($r['cargo']) ?></td>
            <td><?= e($r['email']) ?></td>
            <td>
              <span class="badge bg-<?= $r['status']==='ativo' ? 'success' : 'secondary' ?>">
                <?= e($r['status']) ?>
              </span>
            </td>
            <td class="text-end">
              <a class="btn btn-sm btn-outline-primary" href="<?= e(url('colaboradores/editar.php?id='.$r['id'])) ?>">Editar</a>
              <?php if ($r['status'] === 'ativo'): ?>
                <form method="post" class="d-inline" onsubmit="return confirm('Inativar este colaborador?');">
                  <input type="hidden" name="inativar_id" value="<?= (int)$r['id'] ?>">
                  <button class="btn btn-sm btn-outline-danger">Inativar</button>
                </form>
              <?php endif; ?>
            </td>
          </tr>
        <?php endforeach; ?>
      <?php endif; ?>
    </tbody>
  </table>
</div>

<?php
$pages = (int)ceil($rows / $pp);
if ($pages > 1): ?>
<nav>
  <ul class="pagination">
    <?php for ($i=1; $i <= $pages; $i++): ?>
      <li class="page-item <?= $i==$page ? 'active' : '' ?>">
        <a class="page-link"
           href="?p=<?= $i ?>&q=<?= urlencode($q) ?>&empresa_id=<?= $empresaId ?>&status=<?= urlencode($status) ?>">
          <?= $i ?>
        </a>
      </li>
    <?php endfor; ?>
  </ul>
</nav>
<?php endif; ?>

<?php include __DIR__ . '/../../app/partials/foot.php'; ?>
