<?php
// public/execucoes/nova.php
require_once __DIR__ . '/../../app/core/auth.php';
require_login();

require_once __DIR__ . '/../../app/core/rbac.php';
require_once __DIR__ . '/../../app/config/db.php';
require_once __DIR__ . '/../../app/core/helpers.php';

require_role('empresa_user'); // somente empresa_user cria execuções pelo painel

$u = current_user();
$empresaId = (int)($u['empresa_id'] ?? 0);
$checklistId = (int)($_GET['checklist_id'] ?? 0);

if ($empresaId <= 0 || $checklistId <= 0) {
  http_response_code(400);
  echo 'Parâmetros inválidos.'; exit;
}

// valida checklist pertence à empresa e está ativo
$st = $pdo->prepare("SELECT id FROM checklists WHERE id=? AND empresa_id=? AND status='ativo' LIMIT 1");
$st->execute([$checklistId, $empresaId]);
if (!$st->fetchColumn()) {
  http_response_code(403);
  echo 'Checklist não disponível para sua empresa.'; exit;
}

// cria execução
$executadoPor = (int)($u['id'] ?? 0);
$ins = $pdo->prepare("
  INSERT INTO execucoes (checklist_id, empresa_id, executado_por, status, iniciado_em)
  VALUES (?, ?, ?, 'em_andamento', NOW())
");
$ok = $ins->execute([$checklistId, $empresaId, $executadoPor]);

if (!$ok) {
  http_response_code(500);
  echo 'Não foi possível iniciar a execução.'; exit;
}

$execId = (int)$pdo->lastInsertId();

// vai para o responder dessa execução
redirect('execucoes/responder.php?id='.$execId);
