<?php
// public/gerencias/editar.php
require_once __DIR__ . '/../../app/core/auth.php';
require_login();

require_once __DIR__ . '/../../app/core/rbac.php';
require_role('admin'); // 🔒 somente admin

require_once __DIR__ . '/../../app/config/db.php';
require_once __DIR__ . '/../../app/core/helpers.php';

$pageTitle = 'Editar Gerência';

/* Carregar registro alvo */
$id = (int)($_GET['id'] ?? 0);
$st = $pdo->prepare("SELECT * FROM gerencias WHERE id=?");
$st->execute([$id]);
$r = $st->fetch();

if (!$r) {
  include __DIR__ . '/../../app/partials/head.php';
  include __DIR__ . '/../../app/partials/topbar.php';
  echo "<div class='container mt-4'><div class='alert alert-danger'>Registro não encontrado.</div></div>";
  include __DIR__ . '/../../app/partials/foot.php';
  exit;
}

/* Empresas ativas para o select */
$empresas = $pdo->query("
  SELECT id, razao_social
    FROM empresas
   WHERE status='ativo'
   ORDER BY razao_social
")->fetchAll();

/* Estado do form */
$errors = [];
$old = [
  'empresa_id'  => $_POST['empresa_id']  ?? $r['empresa_id'],
  'nome'        => $_POST['nome']        ?? $r['nome'],
  'responsavel' => $_POST['responsavel'] ?? ($r['responsavel'] ?? ''),
  'status'      => $_POST['status']      ?? $r['status'],
];

/* POST: salvar */
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $empresa_id = (int)($_POST['empresa_id'] ?? 0);
  $nome       = trim($_POST['nome'] ?? '');
  $resp       = trim($_POST['responsavel'] ?? '');
  $status     = $_POST['status'] ?? 'ativo';

  // validações
  if ($empresa_id <= 0) {
    $errors[] = 'Selecione a empresa.';
  } else {
    $chk = $pdo->prepare("SELECT COUNT(*) FROM empresas WHERE id=? AND status='ativo'");
    $chk->execute([$empresa_id]);
    if (!(int)$chk->fetchColumn()) {
      $errors[] = 'Empresa inválida ou inativa.';
    }
  }

  if ($nome === '') {
    $errors[] = 'Nome da Gerência é obrigatório.';
  }

  if (!in_array($status, ['ativo','inativo'], true)) {
    $errors[] = 'Status inválido.';
  }

  if (!$errors) {
    $up = $pdo->prepare("
      UPDATE gerencias
         SET empresa_id = ?, nome = ?, responsavel = ?, status = ?
       WHERE id = ?
    ");
    $ok = $up->execute([$empresa_id, $nome, $resp !== '' ? $resp : null, $status, $id]);

    if ($ok) {
      // Redireciona com flag de sucesso
      redirect('gerencias/editar.php?id='.$id.'&ok=1');
    } else {
      $errors[] = 'Não foi possível salvar as alterações.';
    }
  }
}

/* View */
include __DIR__ . '/../../app/partials/head.php';
include __DIR__ . '/../../app/partials/topbar.php';
?>

<div class="container mt-4">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h1 class="h4 m-0">Editar gerência</h1>
    <div class="d-flex gap-2">
      <span class="badge bg-secondary align-self-center">ID: <?= (int)$id ?></span>
      <a href="<?= e(url('gerencias/index.php')) ?>" class="btn btn-outline-secondary btn-sm">Voltar</a>
    </div>
  </div>

  <?php if (isset($_GET['ok'])): ?>
    <div class="alert alert-success">Gerência atualizada com sucesso.</div>
  <?php endif; ?>

  <?php if ($errors): ?>
    <div class="alert alert-danger">
      <strong>Não foi possível salvar:</strong><br>
      <?= implode('<br>', array_map('e', $errors)) ?>
    </div>
  <?php endif; ?>

  <div class="card">
    <div class="card-body">
      <form method="post" class="row g-3">
        <div class="col-12 col-md-6">
          <label class="form-label">Empresa</label>
          <select name="empresa_id" class="form-select" required>
            <?php foreach ($empresas as $e): ?>
              <option value="<?= (int)$e['id'] ?>"
                <?= ((string)$old['empresa_id'] === (string)$e['id']) ? 'selected' : '' ?>>
                <?= e($e['razao_social']) ?>
              </option>
            <?php endforeach; ?>
          </select>
        </div>

        <div class="col-12 col-md-6">
          <label class="form-label">Nome da Gerência</label>
          <input name="nome" class="form-control" required value="<?= e($old['nome']) ?>">
        </div>

        <div class="col-12">
          <label class="form-label">Responsável <span class="text-muted'>(opcional)</span></label>
          <input name="responsavel" class="form-control" value="<?= e($old['responsavel']) ?>">
        </div>

        <div class="col-12 col-md-3">
          <label class="form-label">Status</label>
          <select name="status" class="form-select">
            <option value="ativo"   <?= $old['status']==='ativo'?'selected':'' ?>>Ativo</option>
            <option value="inativo" <?= $old['status']==='inativo'?'selected':'' ?>>Inativo</option>
          </select>
        </div>

        <div class="col-12">
          <button class="btn btn-primary">Salvar</button>
          <a href="<?= e(url('gerencias/index.php')) ?>" class="btn btn-outline-secondary">Cancelar</a>
        </div>
      </form>
    </div>
  </div>
</div>

<?php include __DIR__ . '/../../app/partials/foot.php'; ?>
