<?php
// public/gerencias/novo.php
require_once __DIR__ . '/../../app/core/auth.php';
require_login();

require_once __DIR__ . '/../../app/core/rbac.php';
require_role('admin'); // 🔒 apenas admin

require_once __DIR__ . '/../../app/config/db.php';
require_once __DIR__ . '/../../app/core/helpers.php';

$pageTitle = 'Nova Gerência';

/* Carrega empresas ativas para o select */
$empresas = $pdo->query("
  SELECT id, razao_social
    FROM empresas
   WHERE status='ativo'
   ORDER BY razao_social
")->fetchAll();

/* Estado do form */
$errors = [];
$old = [
  'empresa_id' => $_POST['empresa_id'] ?? '',
  'nome'       => $_POST['nome'] ?? '',
  'responsavel'=> $_POST['responsavel'] ?? '',
];

/* POST */
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $empresa_id = (int)($_POST['empresa_id'] ?? 0);
  $nome       = trim($_POST['nome'] ?? '');
  $resp       = trim($_POST['responsavel'] ?? '');

  // validações
  if ($empresa_id <= 0) {
    $errors[] = 'Selecione a empresa.';
  } else {
    $chk = $pdo->prepare("SELECT COUNT(*) FROM empresas WHERE id=? AND status='ativo'");
    $chk->execute([$empresa_id]);
    if (!(int)$chk->fetchColumn()) {
      $errors[] = 'Empresa inválida ou inativa.';
    }
  }

  if ($nome === '') {
    $errors[] = 'Nome da Gerência é obrigatório.';
  }

  if (!$errors) {
    // ajusta INSERT conforme sua tabela (se não tiver criado_em, remova NOW())
    $ins = $pdo->prepare("
      INSERT INTO gerencias (empresa_id, nome, responsavel, status, criado_em)
      VALUES (?, ?, ?, 'ativo', NOW())
    ");
    if ($ins->execute([$empresa_id, $nome, $resp !== '' ? $resp : null])) {
      redirect('gerencias/index.php');
    } else {
      $errors[] = 'Não foi possível salvar a gerência.';
    }
  }
}

include __DIR__ . '/../../app/partials/head.php';
include __DIR__ . '/../../app/partials/topbar.php';
?>

<div class="container mt-4">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h1 class="h4 m-0">Nova gerência</h1>
    <a href="<?= e(url('gerencias/index.php')) ?>" class="btn btn-outline-secondary">Voltar</a>
  </div>

  <?php if ($errors): ?>
    <div class="alert alert-danger">
      <strong>Não foi possível salvar:</strong><br>
      <?= implode('<br>', array_map('e', $errors)) ?>
    </div>
  <?php endif; ?>

  <div class="card">
    <div class="card-body">
      <form method="post" class="row g-3">
        <div class="col-12 col-md-6">
          <label class="form-label">Empresa</label>
          <select name="empresa_id" class="form-select" required>
            <option value="">Selecione</option>
            <?php foreach ($empresas as $e): ?>
              <option value="<?= (int)$e['id'] ?>" <?= ((string)$old['empresa_id'] === (string)$e['id']) ? 'selected' : '' ?>>
                <?= e($e['razao_social']) ?>
              </option>
            <?php endforeach; ?>
          </select>
        </div>

        <div class="col-12 col-md-6">
          <label class="form-label">Nome da Gerência</label>
          <input name="nome" class="form-control" required value="<?= e($old['nome']) ?>">
        </div>

        <div class="col-12">
          <label class="form-label">Responsável <span class="text-muted">(opcional)</span></label>
          <input name="responsavel" class="form-control" value="<?= e($old['responsavel']) ?>">
        </div>

        <div class="col-12">
          <button class="btn btn-primary">Salvar</button>
          <a href="<?= e(url('gerencias/index.php')) ?>" class="btn btn-outline-secondary">Cancelar</a>
        </div>
      </form>
    </div>
  </div>
</div>

<?php include __DIR__ . '/../../app/partials/foot.php'; ?>
