<?php
// app/core/auth.php
if (session_status() === PHP_SESSION_NONE) {
  session_start();
}

require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/helpers.php';

function login(string $email, string $senha): bool {
  global $pdo;
  $sql = "
    SELECT u.*, r.nome AS role
      FROM usuarios u
      LEFT JOIN roles r ON r.id = u.role_id
     WHERE u.email = ? AND u.status = 'ativo'
     LIMIT 1
  ";
  $st = $pdo->prepare($sql);
  $st->execute([$email]);
  $u = $st->fetch();
  if (!$u) return false;
  if (!password_verify($senha, $u['senha_hash'])) return false;

  $_SESSION['user'] = [
    'id'             => (int)$u['id'],
    'nome'           => $u['nome'],
    'email'          => $u['email'],
    'empresa_id'     => $u['empresa_id'] !== null ? (int)$u['empresa_id'] : null,
    'gerencia_id'    => $u['gerencia_id'] !== null ? (int)$u['gerencia_id'] : null,
    'colaborador_id' => $u['colaborador_id'] !== null ? (int)$u['colaborador_id'] : null,
    'role'           => $u['role'] ?: null,
  ];
  return true;
}

function logout(): void {
  $_SESSION = [];
  if (ini_get('session.use_cookies')) {
    $params = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000, $params['path'], $params['domain'], $params['secure'], $params['httponly']);
  }
  session_destroy();
}

function require_login(): void {
  if (empty($_SESSION['user'])) {
    redirect('login.php');
  }
}

function current_user(): ?array {
  return $_SESSION['user'] ?? null;
}
