-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/
--
-- Host: 127.0.0.1
-- Tempo de geração: 02/09/2025 às 22:51
-- Versão do servidor: 10.4.32-MariaDB
-- Versão do PHP: 8.2.12

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Banco de dados: `checklist`
--

-- --------------------------------------------------------

--
-- Estrutura para tabela `checklists`
--

CREATE TABLE `checklists` (
  `id` int(11) NOT NULL,
  `empresa_id` int(11) NOT NULL,
  `parent_checklist_id` int(11) DEFAULT NULL,
  `versao` int(11) NOT NULL DEFAULT 1,
  `titulo` varchar(200) NOT NULL,
  `descricao` text DEFAULT NULL,
  `status` enum('ativo','inativo','executado') NOT NULL DEFAULT 'ativo',
  `criado_em` datetime DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Estrutura para tabela `checklist_perguntas`
--

CREATE TABLE `checklist_perguntas` (
  `id` int(11) NOT NULL,
  `pergunta_uid` char(36) NOT NULL,
  `replaces_uid` char(36) DEFAULT NULL,
  `checklist_id` int(11) NOT NULL,
  `gerencia_id` int(11) NOT NULL,
  `setor_id` int(11) NOT NULL,
  `texto` text NOT NULL,
  `peso` decimal(5,2) NOT NULL DEFAULT 1.00,
  `ordem` int(11) NOT NULL DEFAULT 1,
  `criado_em` datetime DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Estrutura para tabela `checklist_pergunta_responsaveis`
--

CREATE TABLE `checklist_pergunta_responsaveis` (
  `id` int(11) NOT NULL,
  `pergunta_id` int(11) NOT NULL,
  `colaborador_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Estrutura para tabela `colaboradores`
--

CREATE TABLE `colaboradores` (
  `id` int(11) NOT NULL,
  `empresa_id` int(11) NOT NULL,
  `nome` varchar(160) NOT NULL,
  `cargo` varchar(120) DEFAULT NULL,
  `email` varchar(160) DEFAULT NULL,
  `status` enum('ativo','inativo') NOT NULL DEFAULT 'ativo',
  `criado_em` datetime DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Despejando dados para a tabela `colaboradores`
--

INSERT INTO `colaboradores` (`id`, `empresa_id`, `nome`, `cargo`, `email`, `status`, `criado_em`) VALUES
(2, 2, 'Marcos', 'Aux. Serviços Gerais', '', 'ativo', '2025-08-22 08:24:40'),
(3, 2, 'Zelia', 'Cozinheiras', '', 'ativo', '2025-08-22 08:47:41'),
(4, 2, 'Adelia', 'Supervisora de  Qualidade', '', 'ativo', '2025-08-22 08:48:04');

-- --------------------------------------------------------

--
-- Estrutura para tabela `empresas`
--

CREATE TABLE `empresas` (
  `id` int(11) NOT NULL,
  `tipo_pessoa` enum('juridica','fisica') NOT NULL DEFAULT 'juridica',
  `razao_social` varchar(200) DEFAULT NULL,
  `nome_fantasia` varchar(200) DEFAULT NULL,
  `nome` varchar(200) DEFAULT NULL,
  `cnae_codigo` varchar(20) DEFAULT NULL,
  `cnae_descricao` text DEFAULT NULL,
  `cnpj_status` varchar(60) DEFAULT NULL,
  `data_abertura` date DEFAULT NULL,
  `cep` varchar(9) DEFAULT NULL,
  `estado` char(2) DEFAULT NULL,
  `cidade` varchar(120) DEFAULT NULL,
  `endereco` varchar(200) DEFAULT NULL,
  `numero` varchar(20) DEFAULT NULL,
  `complemento` varchar(120) DEFAULT NULL,
  `bairro` varchar(120) DEFAULT NULL,
  `contato_nome` varchar(160) DEFAULT NULL,
  `contato_telefone` varchar(40) DEFAULT NULL,
  `cnpj` varchar(20) DEFAULT NULL,
  `cpf` varchar(14) DEFAULT NULL,
  `observacoes` text DEFAULT NULL,
  `logo` varchar(255) DEFAULT NULL,
  `status` enum('ativo','inativo') NOT NULL DEFAULT 'ativo',
  `criado_em` datetime DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Despejando dados para a tabela `empresas`
--

INSERT INTO `empresas` (`id`, `tipo_pessoa`, `razao_social`, `nome_fantasia`, `nome`, `cnae_codigo`, `cnae_descricao`, `cnpj_status`, `data_abertura`, `cep`, `estado`, `cidade`, `endereco`, `numero`, `complemento`, `bairro`, `contato_nome`, `contato_telefone`, `cnpj`, `cpf`, `observacoes`, `logo`, `status`, `criado_em`) VALUES
(2, 'juridica', 'AVESUL AVICULTURA, ELETRICA E HIDRAULICA LTDA', 'AVESUL AVICULTURA, ELETRICA E HIDRAULICA LTDA', NULL, '4744001', 'Comércio varejista de ferragens e ferramentas', 'ATIVA', '2022-06-21', '99950000', 'RS', 'Tapejara', 'SANTO CANALI, 516', '516', NULL, 'CENTRO', NULL, NULL, '46861462000102', NULL, '', 'logo_68b0be4bb3749.png', 'ativo', '2025-08-22 08:19:13'),
(10, 'juridica', 'MAURICEA ALIMENTOS DO NORDESTE LTDA', 'MAURICEA ALIMENTOS', NULL, '4639701', 'Comércio atacadista de produtos alimentícios em geral', 'ATIVA', '2009-09-10', '44082000', 'BA', 'Feira de Santana', 'BR 342 KM 104 LOTES 02,03 E 04 QUADRA B, S/N', 'S/N', NULL, 'LAGOA SALGADA', NULL, NULL, '12819074001296', NULL, NULL, 'logo_68b0be2ccde65.jpg', 'ativo', '2025-08-22 15:44:56');

-- --------------------------------------------------------

--
-- Estrutura para tabela `execucoes`
--

CREATE TABLE `execucoes` (
  `id` int(11) NOT NULL,
  `checklist_id` int(11) NOT NULL,
  `empresa_id` int(11) NOT NULL,
  `executado_por` int(11) DEFAULT NULL,
  `status` enum('em_andamento','finalizado','parcial','liberada') NOT NULL DEFAULT 'em_andamento',
  `iniciado_em` datetime DEFAULT current_timestamp(),
  `finalizado_em` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Estrutura para tabela `gerencias`
--

CREATE TABLE `gerencias` (
  `id` int(11) NOT NULL,
  `empresa_id` int(11) NOT NULL,
  `nome` varchar(120) NOT NULL,
  `responsavel` varchar(120) DEFAULT NULL,
  `status` enum('ativo','inativo') NOT NULL DEFAULT 'ativo',
  `criado_em` datetime DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Despejando dados para a tabela `gerencias`
--

INSERT INTO `gerencias` (`id`, `empresa_id`, `nome`, `responsavel`, `status`, `criado_em`) VALUES
(2, 2, 'ADMINISTRATIVO', '', 'ativo', '2025-08-22 08:20:17'),
(5, 2, 'QUALIDADE', '', 'ativo', '2025-08-22 08:40:32');

-- --------------------------------------------------------

--
-- Estrutura para tabela `orientacoes_tecnicas`
--

CREATE TABLE `orientacoes_tecnicas` (
  `id` int(11) NOT NULL,
  `execucao_id` int(11) NOT NULL,
  `pergunta_id` int(11) NOT NULL,
  `texto` text DEFAULT NULL,
  `autor_id` int(11) DEFAULT NULL,
  `criado_em` datetime NOT NULL DEFAULT current_timestamp(),
  `atualizado_em` datetime NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Estrutura para tabela `respostas`
--

CREATE TABLE `respostas` (
  `id` int(11) NOT NULL,
  `execucao_id` int(11) NOT NULL,
  `pergunta_id` int(11) NOT NULL,
  `pergunta_uid` char(36) DEFAULT NULL,
  `texto_snapshot` text DEFAULT NULL,
  `peso_snapshot` decimal(10,2) DEFAULT NULL,
  `gerencia_nome_snapshot` varchar(255) DEFAULT NULL,
  `setor_nome_snapshot` varchar(255) DEFAULT NULL,
  `resposta` enum('conforme','nao_conforme') NOT NULL,
  `observacao` text DEFAULT NULL,
  `criado_em` datetime DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Acionadores `respostas`
--
DELIMITER $$
CREATE TRIGGER `trg_respostas_snapshot_before_insert` BEFORE INSERT ON `respostas` FOR EACH ROW BEGIN
  DECLARE v_uid CHAR(36);
  DECLARE v_texto TEXT;
  DECLARE v_peso DECIMAL(10,2);
  DECLARE v_ger VARCHAR(255);
  DECLARE v_setor VARCHAR(255);

  -- Coleta dados atuais da pergunta do checklist
  SELECT p.pergunta_uid, p.texto, p.peso, g.nome, s.nome
    INTO v_uid, v_texto, v_peso, v_ger, v_setor
    FROM checklist_perguntas p
    LEFT JOIN gerencias g ON g.id = p.gerencia_id
    LEFT JOIN setores   s ON s.id = p.setor_id
   WHERE p.id = NEW.pergunta_id
   LIMIT 1;

  -- Preenche snapshot
  SET NEW.pergunta_uid             = v_uid;
  SET NEW.texto_snapshot           = v_texto;
  SET NEW.peso_snapshot            = v_peso;
  SET NEW.gerencia_nome_snapshot   = v_ger;
  SET NEW.setor_nome_snapshot      = v_setor;
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Estrutura para tabela `resposta_fotos`
--

CREATE TABLE `resposta_fotos` (
  `id` int(11) NOT NULL,
  `resposta_id` int(11) NOT NULL,
  `caminho` varchar(255) NOT NULL,
  `criado_em` datetime DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Estrutura para tabela `roles`
--

CREATE TABLE `roles` (
  `id` int(11) NOT NULL,
  `nome` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Despejando dados para a tabela `roles`
--

INSERT INTO `roles` (`id`, `nome`) VALUES
(1, 'admin'),
(3, 'diretor'),
(4, 'empresa_user'),
(2, 'gerente');

-- --------------------------------------------------------

--
-- Estrutura para tabela `setores`
--

CREATE TABLE `setores` (
  `id` int(11) NOT NULL,
  `empresa_id` int(11) NOT NULL,
  `gerencia_id` int(11) NOT NULL,
  `nome` varchar(120) NOT NULL,
  `observacao` varchar(255) DEFAULT NULL,
  `status` enum('ativo','inativo') NOT NULL DEFAULT 'ativo',
  `criado_em` datetime DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Despejando dados para a tabela `setores`
--

INSERT INTO `setores` (`id`, `empresa_id`, `gerencia_id`, `nome`, `observacao`, `status`, `criado_em`) VALUES
(3, 2, 2, 'PÁTIO', 'Aux. Serviços Gerais', 'ativo', '2025-08-22 08:45:32'),
(4, 2, 2, 'REFEITÓRIO ÁREA INTERNA A COZINHA', 'Aux. Serviços Gerais', 'ativo', '2025-08-22 08:46:02'),
(5, 2, 5, 'RESPONSABILIDADES DESTE SETOR RELACIONADAS A GESTÃO AMBIENTAL DA PLANTA DE FORMA GERAL', 'Supervisora de  Qualidade', 'ativo', '2025-08-22 08:46:32');

-- --------------------------------------------------------

--
-- Estrutura para tabela `usuarios`
--

CREATE TABLE `usuarios` (
  `id` int(11) NOT NULL,
  `nome` varchar(120) NOT NULL,
  `email` varchar(160) NOT NULL,
  `senha_hash` varchar(255) NOT NULL,
  `role_id` int(11) NOT NULL DEFAULT 4,
  `colaborador_id` int(11) DEFAULT NULL,
  `empresa_id` int(11) DEFAULT NULL,
  `gerencia_id` int(11) DEFAULT NULL,
  `status` enum('ativo','inativo') NOT NULL DEFAULT 'ativo',
  `criado_em` datetime DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Despejando dados para a tabela `usuarios`
--

INSERT INTO `usuarios` (`id`, `nome`, `email`, `senha_hash`, `role_id`, `colaborador_id`, `empresa_id`, `gerencia_id`, `status`, `criado_em`) VALUES
(1, 'Admin', 'admin@local', '$2y$10$yWmVw3fDRzFJgm5DMQBR6OfYRW2xvZODB/v7sCMFK28fpUuLNKg0G', 1, NULL, NULL, NULL, 'ativo', '2025-08-21 21:02:00'),
(6, 'diretor avesul', 'diretor@avesul.com', '$2y$10$gFea1OmpCIwXf7Qta.v0ueR3tfqCtXq3NNvcPi1Z1dxfyy/4D9jAG', 3, NULL, 2, NULL, 'ativo', '2025-08-27 15:53:45'),
(7, 'gerente avesul', 'gerente@avesul.com', '$2y$10$ZEhH5ft/4onRnghoZpQGF.NFxMev9A6mqTX2LsO6DoOFJLNHfdwD6', 2, NULL, 2, NULL, 'ativo', '2025-08-27 15:54:18'),
(8, 'user avesul', 'user@avesul.com', '$2y$10$aow.fZSd0Etv6t0vrMWrx.kpnzwrX.MUKoXN37clkSqjxP3E2q31y', 4, NULL, 2, NULL, 'ativo', '2025-08-27 15:54:40'),
(9, 'teste', 'teste1@teste.com.br', '$2y$10$EbJKQAnoFB0xdr/a1QuCDOgG9fn6PZgKO/7tlSzPJyR2bZgbIUMw.', 3, NULL, 10, NULL, 'ativo', '2025-08-28 17:15:36');

--
-- Índices para tabelas despejadas
--

--
-- Índices de tabela `checklists`
--
ALTER TABLE `checklists`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_checklists_empresa` (`empresa_id`),
  ADD KEY `idx_checklists_status` (`status`),
  ADD KEY `parent_checklist_id` (`parent_checklist_id`);

--
-- Índices de tabela `checklist_perguntas`
--
ALTER TABLE `checklist_perguntas`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uq_pergunta_uid` (`pergunta_uid`),
  ADD KEY `idx_cp_checklist` (`checklist_id`),
  ADD KEY `idx_cp_gerencia` (`gerencia_id`),
  ADD KEY `idx_cp_setor` (`setor_id`),
  ADD KEY `idx_cp_ordem` (`ordem`),
  ADD KEY `replaces_uid` (`replaces_uid`);

--
-- Índices de tabela `checklist_pergunta_responsaveis`
--
ALTER TABLE `checklist_pergunta_responsaveis`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uq_pergunta_colab` (`pergunta_id`,`colaborador_id`),
  ADD KEY `idx_cpr_pergunta` (`pergunta_id`),
  ADD KEY `idx_cpr_colab` (`colaborador_id`);

--
-- Índices de tabela `colaboradores`
--
ALTER TABLE `colaboradores`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_colab_empresa` (`empresa_id`),
  ADD KEY `idx_colab_status` (`status`);

--
-- Índices de tabela `empresas`
--
ALTER TABLE `empresas`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `cnpj` (`cnpj`),
  ADD KEY `idx_empresas_status` (`status`),
  ADD KEY `idx_empresas_tipo` (`tipo_pessoa`),
  ADD KEY `idx_empresas_cnpj` (`cnpj`),
  ADD KEY `idx_empresas_cpf` (`cpf`),
  ADD KEY `idx_empresas_estado` (`estado`),
  ADD KEY `idx_empresas_cidade` (`cidade`);

--
-- Índices de tabela `execucoes`
--
ALTER TABLE `execucoes`
  ADD PRIMARY KEY (`id`),
  ADD KEY `fk_exec_usuario` (`executado_por`),
  ADD KEY `idx_exec_checklist` (`checklist_id`),
  ADD KEY `idx_exec_empresa` (`empresa_id`),
  ADD KEY `idx_exec_status` (`status`),
  ADD KEY `idx_exec_iniciado` (`iniciado_em`);

--
-- Índices de tabela `gerencias`
--
ALTER TABLE `gerencias`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_gerencias_empresa` (`empresa_id`),
  ADD KEY `idx_gerencias_status` (`status`);

--
-- Índices de tabela `orientacoes_tecnicas`
--
ALTER TABLE `orientacoes_tecnicas`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uniq_exec_pergunta` (`execucao_id`,`pergunta_id`),
  ADD KEY `idx_exec` (`execucao_id`),
  ADD KEY `idx_perg` (`pergunta_id`);

--
-- Índices de tabela `respostas`
--
ALTER TABLE `respostas`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `uq_exec_pergunta` (`execucao_id`,`pergunta_id`),
  ADD KEY `idx_respostas_execucao` (`execucao_id`),
  ADD KEY `idx_respostas_pergunta` (`pergunta_id`),
  ADD KEY `execucao_id` (`execucao_id`),
  ADD KEY `pergunta_id` (`pergunta_id`),
  ADD KEY `pergunta_uid` (`pergunta_uid`);

--
-- Índices de tabela `resposta_fotos`
--
ALTER TABLE `resposta_fotos`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_fotos_resposta` (`resposta_id`);

--
-- Índices de tabela `roles`
--
ALTER TABLE `roles`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `nome` (`nome`);

--
-- Índices de tabela `setores`
--
ALTER TABLE `setores`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_setores_empresa` (`empresa_id`),
  ADD KEY `idx_setores_gerencia` (`gerencia_id`),
  ADD KEY `idx_setores_status` (`status`);

--
-- Índices de tabela `usuarios`
--
ALTER TABLE `usuarios`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `email` (`email`),
  ADD KEY `idx_usuarios_email` (`email`),
  ADD KEY `idx_usuarios_empresa` (`empresa_id`),
  ADD KEY `idx_usuarios_gerencia` (`gerencia_id`),
  ADD KEY `idx_usuarios_status` (`status`),
  ADD KEY `fk_usuarios_role` (`role_id`),
  ADD KEY `fk_usuarios_colab` (`colaborador_id`);

--
-- AUTO_INCREMENT para tabelas despejadas
--

--
-- AUTO_INCREMENT de tabela `checklists`
--
ALTER TABLE `checklists`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=10;

--
-- AUTO_INCREMENT de tabela `checklist_perguntas`
--
ALTER TABLE `checklist_perguntas`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=21;

--
-- AUTO_INCREMENT de tabela `checklist_pergunta_responsaveis`
--
ALTER TABLE `checklist_pergunta_responsaveis`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=26;

--
-- AUTO_INCREMENT de tabela `colaboradores`
--
ALTER TABLE `colaboradores`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT de tabela `empresas`
--
ALTER TABLE `empresas`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=14;

--
-- AUTO_INCREMENT de tabela `execucoes`
--
ALTER TABLE `execucoes`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=18;

--
-- AUTO_INCREMENT de tabela `gerencias`
--
ALTER TABLE `gerencias`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- AUTO_INCREMENT de tabela `orientacoes_tecnicas`
--
ALTER TABLE `orientacoes_tecnicas`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT de tabela `respostas`
--
ALTER TABLE `respostas`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=43;

--
-- AUTO_INCREMENT de tabela `resposta_fotos`
--
ALTER TABLE `resposta_fotos`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=32;

--
-- AUTO_INCREMENT de tabela `roles`
--
ALTER TABLE `roles`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- AUTO_INCREMENT de tabela `setores`
--
ALTER TABLE `setores`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- AUTO_INCREMENT de tabela `usuarios`
--
ALTER TABLE `usuarios`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=10;

--
-- Restrições para tabelas despejadas
--

--
-- Restrições para tabelas `checklists`
--
ALTER TABLE `checklists`
  ADD CONSTRAINT `fk_checklists_empresa` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE;

--
-- Restrições para tabelas `checklist_perguntas`
--
ALTER TABLE `checklist_perguntas`
  ADD CONSTRAINT `fk_cp_checklist` FOREIGN KEY (`checklist_id`) REFERENCES `checklists` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_cp_gerencia` FOREIGN KEY (`gerencia_id`) REFERENCES `gerencias` (`id`),
  ADD CONSTRAINT `fk_cp_setor` FOREIGN KEY (`setor_id`) REFERENCES `setores` (`id`);

--
-- Restrições para tabelas `checklist_pergunta_responsaveis`
--
ALTER TABLE `checklist_pergunta_responsaveis`
  ADD CONSTRAINT `fk_cpr_colab` FOREIGN KEY (`colaborador_id`) REFERENCES `colaboradores` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_cpr_pergunta` FOREIGN KEY (`pergunta_id`) REFERENCES `checklist_perguntas` (`id`) ON DELETE CASCADE;

--
-- Restrições para tabelas `colaboradores`
--
ALTER TABLE `colaboradores`
  ADD CONSTRAINT `fk_colab_empresa` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE;

--
-- Restrições para tabelas `execucoes`
--
ALTER TABLE `execucoes`
  ADD CONSTRAINT `fk_exec_checklist` FOREIGN KEY (`checklist_id`) REFERENCES `checklists` (`id`),
  ADD CONSTRAINT `fk_exec_empresa` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`),
  ADD CONSTRAINT `fk_exec_usuario` FOREIGN KEY (`executado_por`) REFERENCES `usuarios` (`id`) ON DELETE SET NULL;

--
-- Restrições para tabelas `gerencias`
--
ALTER TABLE `gerencias`
  ADD CONSTRAINT `fk_gerencias_empresa` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE;

--
-- Restrições para tabelas `respostas`
--
ALTER TABLE `respostas`
  ADD CONSTRAINT `fk_resp_exec` FOREIGN KEY (`execucao_id`) REFERENCES `execucoes` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_resp_pergunta` FOREIGN KEY (`pergunta_id`) REFERENCES `checklist_perguntas` (`id`);

--
-- Restrições para tabelas `resposta_fotos`
--
ALTER TABLE `resposta_fotos`
  ADD CONSTRAINT `fk_foto_resposta` FOREIGN KEY (`resposta_id`) REFERENCES `respostas` (`id`) ON DELETE CASCADE;

--
-- Restrições para tabelas `setores`
--
ALTER TABLE `setores`
  ADD CONSTRAINT `fk_setores_empresa` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `fk_setores_gerencia` FOREIGN KEY (`gerencia_id`) REFERENCES `gerencias` (`id`) ON DELETE CASCADE;

--
-- Restrições para tabelas `usuarios`
--
ALTER TABLE `usuarios`
  ADD CONSTRAINT `fk_usuarios_colab` FOREIGN KEY (`colaborador_id`) REFERENCES `colaboradores` (`id`),
  ADD CONSTRAINT `fk_usuarios_empresa` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `fk_usuarios_gerencia` FOREIGN KEY (`gerencia_id`) REFERENCES `gerencias` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `fk_usuarios_role` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`);
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
