<?php
require_once __DIR__ . '/../../app/config/db.php';
require_once __DIR__ . '/../../app/core/helpers.php';

$email = trim($_POST['email'] ?? '');
$senha = $_POST['senha'] ?? '';

if ($email === '' || $senha === '') redirect('login.php?err=1');

/* autentica */
$st = $pdo->prepare("SELECT id, email, senha_hash, status FROM usuarios WHERE email=? LIMIT 1");
$st->execute([$email]);
$u = $st->fetch();

if (!$u || $u['status']!=='ativo' || !password_verify($senha, $u['senha_hash'])) {
  redirect('login.php?err=1');
}

/* carrega user + role pelo role_id */
$qd = $pdo->prepare("
  SELECT u.*, r.nome AS role_nome
  FROM usuarios u
  LEFT JOIN roles r ON r.id = u.role_id
  WHERE u.id = ?
");
$qd->execute([$u['id']]);
$usr = $qd->fetch();

session_start();
$_SESSION['user'] = [
  'id'             => (int)$usr['id'],
  'nome'           => $usr['nome'],
  'email'          => $usr['email'],
  'empresa_id'     => $usr['empresa_id'] ? (int)$usr['empresa_id'] : null,
  'gerencia_id'    => $usr['gerencia_id'] ? (int)$usr['gerencia_id'] : null,
  'colaborador_id' => $usr['colaborador_id'] ? (int)$usr['colaborador_id'] : null,
  'role'           => $usr['role_nome'], // 'admin' | 'gerente' | 'diretor' | 'empresa_user'
];

/* rota inicial por perfil */
$role = $_SESSION['user']['role'] ?? null;
if ($role === 'gerente' || $role === 'diretor') {
  redirect('../relatorios/consolidado.php');
} elseif ($role === 'empresa_user') {
  redirect('../execucoes/minhas.php');
} else {
  redirect('../index.php'); // admin/default
}
