<?php
require_once __DIR__ . '/../../app/core/auth.php';
require_login(); require_once __DIR__ . '/../../app/config/db.php';
$pageTitle = 'Empresas';
include __DIR__ . '/../../app/partials/head.php';
include __DIR__ . '/../../app/partials/topbar.php';

$q = trim($_GET['q'] ?? '');
$page = max(1, (int)($_GET['p'] ?? 1));
$pp = 10;
$off = ($page-1)*$pp;

$params = [];
$where = "WHERE 1=1";
if ($q !== '') {
  $where .= " AND (razao_social LIKE :q OR cnpj LIKE :q)";
  $params[':q'] = "%$q%";
}
$total = $pdo->prepare("SELECT COUNT(*) c FROM empresas $where");
$total->execute($params);
$rows = (int)$total->fetch()['c'];

$sql = $pdo->prepare("SELECT * FROM empresas $where ORDER BY criado_em DESC, id DESC LIMIT $pp OFFSET $off");
$sql->execute($params);
$data = $sql->fetchAll();
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h1 class="h4 m-0">Empresas</h1>
  <a href="<?= e(url('empresas/novo.php')) ?>" class="btn btn-primary">Nova empresa</a>
</div>

<form class="row g-2 mb-3">
  <div class="col-auto">
    <input type="text" name="q" class="form-control" placeholder="Buscar por razão social/CNPJ" value="<?= e($q) ?>">
  </div>
  <div class="col-auto">
    <button class="btn btn-outline-secondary">Filtrar</button>
    <a class="btn btn-link" href="<?= e(url('empresas/index.php')) ?>">Limpar</a>
  </div>
</form>

<div class="table-responsive">
<table class="table table-striped align-middle">
  <thead><tr>
    <th>ID</th><th>Razão Social</th><th>CNPJ</th><th>Status</th><th></th>
  </tr></thead>
  <tbody>
  <?php foreach($data as $r): ?>
    <tr>
      <td><?= (int)$r['id'] ?></td>
      <td><?= e($r['razao_social']) ?></td>
      <td><?= e($r['cnpj']) ?></td>
      <td><span class="badge bg-<?= $r['status']=='ativo'?'success':'secondary' ?>"><?= e($r['status']) ?></span></td>
      <td class="text-end">
        <a class="btn btn-sm btn-outline-primary" href="<?= e(url('empresas/editar.php?id='.$r['id'])) ?>">Editar</a>
      </td>
    </tr>
  <?php endforeach; ?>
  </tbody>
</table>
</div>

<?php
$pages = (int)ceil($rows/$pp);
if ($pages>1): ?>
<nav>
  <ul class="pagination">
    <?php for($i=1;$i<=$pages;$i++): ?>
      <li class="page-item <?= $i==$page?'active':'' ?>">
        <a class="page-link" href="?p=<?= $i ?>&q=<?= urlencode($q) ?>"><?= $i ?></a>
      </li>
    <?php endfor; ?>
  </ul>
</nav>
<?php endif; ?>

<?php include __DIR__ . '/../../app/partials/foot.php'; ?>
