<?php
// public/execucoes/iniciar.php
require_once __DIR__ . '/../../app/core/auth.php';
require_login();

require_once __DIR__ . '/../../app/core/rbac.php';
require_role('empresa_user');

require_once __DIR__ . '/../../app/config/db.php';
require_once __DIR__ . '/../../app/core/helpers.php';

$u = current_user();
$userId    = (int)($u['id'] ?? 0);
$empresaId = (int)($u['empresa_id'] ?? 0);

$execId = (int)($_GET['id'] ?? 0);
if ($execId <= 0 || $empresaId <= 0) { http_response_code(400); exit('Requisição inválida.'); }

// Tenta “reservar” a execução liberada para este usuário
$up = $pdo->prepare("
  UPDATE execucoes
     SET status='em_andamento', executado_por=?, iniciado_em=NOW()
   WHERE id=? AND empresa_id=? AND status='liberada'
  LIMIT 1
");
$ok = $up->execute([$userId, $execId, $empresaId]);

if ($ok && $up->rowCount() === 1) {
  // deu certo, segue para responder
  redirect('responder.php?id='.$execId);
  exit;
}

// Se já está em andamento E é do próprio usuário, apenas continuar
$ck = $pdo->prepare("SELECT status, executado_por FROM execucoes WHERE id=? AND empresa_id=?");
$ck->execute([$execId, $empresaId]);
$row = $ck->fetch(PDO::FETCH_ASSOC);
if ($row && $row['status']==='em_andamento' && (int)$row['executado_por']===$userId) {
  redirect('responder.php?id='.$execId);
  exit;
}

// Qualquer outra situação: negar
include __DIR__ . '/../../app/partials/head.php';
include __DIR__ . '/../../app/partials/topbar.php';
?>
<div class="container mt-4">
  <div class="alert alert-danger">
    Não foi possível iniciar esta execução. Ela pode ter sido retirada por outro usuário,
    não pertence à sua empresa ou não está mais liberada.
  </div>
  <a class="btn btn-outline-secondary" href="<?= e(url('empresa_user/index.php')) ?>">Voltar</a>
</div>
<?php include __DIR__ . '/../../app/partials/foot.php'; ?>
