<?php
// public/execucoes/orientacoes.php
require_once __DIR__ . '/../../app/core/auth.php';
require_login();

require_once __DIR__ . '/../../app/core/rbac.php';
require_role('admin'); // ajuste se quiser permitir gerente etc.

require_once __DIR__ . '/../../app/config/db.php';
require_once __DIR__ . '/../../app/core/helpers.php';

/*
  Requer tabela (veja DDL no final):
  orientacoes_tecnicas(
    id PK, execucao_id, pergunta_id, texto, autor_id, criado_em, atualizado_em,
    UNIQUE (execucao_id, pergunta_id)
  )
*/

$execucaoId = (int)($_GET['execucao_id'] ?? 0);

// Carrega execução + checklist + empresa
$st = $pdo->prepare("
  SELECT x.*, c.titulo AS checklist_titulo, e.razao_social AS empresa_nome
    FROM execucoes x
    JOIN checklists c ON c.id = x.checklist_id
    JOIN empresas   e ON e.id = x.empresa_id
   WHERE x.id = ?
");
$st->execute([$execucaoId]);
$exec = $st->fetch(PDO::FETCH_ASSOC);

if (!$exec) {
  $pageTitle = 'Orientação técnica';
  include __DIR__ . '/../../app/partials/head.php';
  include __DIR__ . '/../../app/partials/topbar.php';
  echo "<div class='container mt-4'><div class='alert alert-danger'>Execução não encontrada.</div></div>";
  include __DIR__ . '/../../app/partials/foot.php';
  exit;
}

$pageTitle = 'Orientação técnica · Execução #'.$execucaoId;

// POST: salvar orientações (uma por pergunta)
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['ori']) && is_array($_POST['ori'])) {
  $autorId = (int)(current_user()['id'] ?? 0);
  $ins = $pdo->prepare("
    INSERT INTO orientacoes_tecnicas (execucao_id, pergunta_id, texto, autor_id, criado_em, atualizado_em)
    VALUES (?, ?, ?, ?, NOW(), NOW())
    ON DUPLICATE KEY UPDATE texto = VALUES(texto), autor_id = VALUES(autor_id), atualizado_em = NOW()
  ");
  foreach ($_POST['ori'] as $perguntaId => $texto) {
    $texto = trim((string)$texto);
    $perguntaId = (int)$perguntaId;
    $ins->execute([$execucaoId, $perguntaId, $texto, $autorId]);
  }
  // volta para a própria página com aviso
  header('Location: '.url('execucoes/orientacoes.php?execucao_id='.$execucaoId.'&ok=1'));
  exit;
}

// Carrega perguntas + respostas + fotos + orientação existente
$q = $pdo->prepare("
  SELECT
    p.id               AS pergunta_id,
    p.texto            AS pergunta_texto,
    p.peso,
    g.nome             AS gerencia_nome,
    s.nome             AS setor_nome,
    r.id               AS resposta_id,
    r.resposta,
    r.observacao,
    o.texto            AS orientacao_texto
  FROM checklist_perguntas p
  LEFT JOIN respostas r
         ON r.pergunta_id = p.id AND r.execucao_id = ?
  LEFT JOIN orientacoes_tecnicas o
         ON o.execucao_id = ? AND o.pergunta_id = p.id
  JOIN gerencias g ON g.id = p.gerencia_id
  JOIN setores   s ON s.id = p.setor_id
 WHERE p.checklist_id = ?
 ORDER BY g.nome, s.nome, p.id
");
$q->execute([$execucaoId, $execucaoId, (int)$exec['checklist_id']]);
$rows = $q->fetchAll(PDO::FETCH_ASSOC);

// Fotos por resposta
$fotos = [];
if ($rows) {
  $respostaIds = array_values(array_filter(array_column($rows, 'resposta_id')));
  if ($respostaIds) {
    $in = implode(',', array_fill(0, count($respostaIds), '?'));
    $qf = $pdo->prepare("SELECT resposta_id, caminho FROM resposta_fotos WHERE resposta_id IN ($in) ORDER BY id");
    $qf->execute($respostaIds);
    foreach ($qf->fetchAll(PDO::FETCH_ASSOC) as $f) {
      $rid = (int)$f['resposta_id'];
      if (!isset($fotos[$rid])) $fotos[$rid] = [];
      $fotos[$rid][] = $f['caminho'];
    }
  }
}

// Agrupa por Gerência > Setor
$tree = [];
foreach ($rows as $r) {
  $gk = $r['gerencia_nome'];
  $sk = $r['setor_nome'];
  if (!isset($tree[$gk])) $tree[$gk] = [];
  if (!isset($tree[$gk][$sk])) $tree[$gk][$sk] = [];
  $tree[$gk][$sk][] = $r;
}

include __DIR__ . '/../../app/partials/head.php';
include __DIR__ . '/../../app/partials/topbar.php';

function badge_resposta($v) {
  if ($v === 'conforme')      return '<span class="badge bg-success">Conforme</span>';
  if ($v === 'nao_conforme')  return '<span class="badge bg-danger">Não conforme</span>';
  if ($v === 'nao_aplicavel') return '<span class="badge bg-secondary">N/A</span>';
  return '<span class="badge bg-light text-dark">—</span>';
}
?>
<style>
.section-title{background:#0B3040;color:#fff;padding:.5rem .75rem;border-radius:.5rem;margin-top:1rem}
.section-sub{background:#F1A983;color:#000;padding:.4rem .6rem;border-radius:.5rem;margin:.5rem 0}
.card-q{border:1px solid #e9ecef;border-radius:.75rem}
.photo{height:70px;border:1px solid #ddd;padding:2px;border-radius:.4rem;margin-right:6px;background:#fff}
.sticky-actions{position:sticky;top:0;z-index:10;background:#fff;border-bottom:1px solid #eee;padding:.6rem 0;margin-bottom:.6rem}
</style>

<div class="container my-4">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <div>
      <h1 class="h5 m-0">Orientação técnica — Execução #<?= (int)$execucaoId ?></h1>
      <div class="small text-muted">
        Empresa: <strong><?= e($exec['empresa_nome']) ?></strong> ·
        Checklist: <strong><?= e($exec['checklist_titulo']) ?></strong> ·
        Status: <span class="badge <?= $exec['status']==='finalizado'?'bg-success':($exec['status']==='em_andamento'?'bg-warning text-dark':'bg-secondary') ?>"><?= e($exec['status']) ?></span>
      </div>
    </div>
    <div class="d-flex gap-2">
      <a class="btn btn-outline-secondary" href="<?= e(url('checklists/editar.php?id='.(int)$exec['checklist_id'].'&tab=execucoes')) ?>">Voltar</a>
    </div>
  </div>

  <?php if (!empty($_GET['ok'])): ?>
  <div class="alert alert-success">Orientações salvas.</div>
  <?php endif; ?>

  <form method="post">
    <?php if (!$tree): ?>
      <div class="alert alert-info">Sem perguntas para este checklist.</div>
    <?php else: ?>
      <?php foreach ($tree as $gerencia => $setores): ?>
        <div class="section-title"><strong>Gerência:</strong> <?= e($gerencia) ?></div>

        <?php foreach ($setores as $setor => $qs): ?>
          <div class="section-sub"><strong>Setor:</strong> <?= e($setor) ?></div>

          <?php foreach ($qs as $r): ?>
            <div class="card card-q mb-3">
              <div class="card-body">
                <div class="d-flex justify-content-between">
                  <div class="me-3">
                    <div class="mb-1"><?= nl2br(e($r['pergunta_texto'])) ?></div>
                    <div class="small text-muted">
                      Peso: <strong><?= (int)$r['peso'] ?></strong> ·
                      Resposta: <?= badge_resposta($r['resposta']) ?>
                      <?php if ($r['observacao']): ?>
                        · Observação: <em><?= e($r['observacao']) ?></em>
                      <?php endif; ?>
                    </div>
                  </div>
                </div>

                <?php
                  $rid = (int)($r['resposta_id'] ?? 0);
                  $imgs = $rid && !empty($fotos[$rid]) ? $fotos[$rid] : [];
                  if ($imgs):
                ?>
                <div class="mt-2">
                  <?php foreach ($imgs as $c): ?>
                    <a href="<?= e(url('../'.$c)) ?>" target="_blank">
                      <img src="<?= e(url('../'.$c)) ?>" alt="foto" class="photo">
                    </a>
                  <?php endforeach; ?>
                </div>
                <?php endif; ?>

                <div class="mt-3">
                  <label class="form-label">Orientação técnica (para esta pergunta)</label>
                  <textarea name="ori[<?= (int)$r['pergunta_id'] ?>]" class="form-control" rows="3" placeholder="Escreva a orientação técnica…"><?= e($r['orientacao_texto'] ?? '') ?></textarea>
                </div>
              </div>
            </div>
          <?php endforeach; ?>
        <?php endforeach; ?>
      <?php endforeach; ?>

      <div class="d-flex justify-content-end">
        <button class="btn btn-primary">Salvar orientações</button>
      </div>
    <?php endif; ?>
  </form>
</div>

<?php include __DIR__ . '/../../app/partials/foot.php'; ?>
