<?php
// public/execucoes/responder.php
require_once __DIR__ . '/../../app/core/auth.php';
require_login();

require_once __DIR__ . '/../../app/core/rbac.php';
require_role('empresa_user');

require_once __DIR__ . '/../../app/config/db.php';
require_once __DIR__ . '/../../app/core/helpers.php';

$u = current_user();
$empresaId = (int)($u['empresa_id'] ?? 0);
$colaboradorId = (int)($u['colaborador_id'] ?? 0); // se você usa current_scope(), pode trocar aqui

$execId = (int)($_GET['id'] ?? 0);
if ($execId <= 0) redirect('empresa_user/index.php');

// carrega execução e valida empresa/status
$st = $pdo->prepare("
  SELECT x.*, c.titulo
    FROM execucoes x
    JOIN checklists c ON c.id = x.checklist_id
   WHERE x.id = ? AND x.empresa_id = ?
   LIMIT 1
");
$st->execute([$execId, $empresaId]);
$exec = $st->fetch(PDO::FETCH_ASSOC);
if (!$exec) { http_response_code(404); echo 'Execução não encontrada.'; exit; }

if ($exec['status'] !== 'em_andamento') {
  // já finalizada — envia para o detalhe
  redirect('execucoes/detalhe.php?id='.$execId);
}

$pageTitle = 'Responder Checklist';

$errors = [];
$okMsg  = null;

// salva respostas (incremental)
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['salvar'])) {
  $resps  = $_POST['resposta']   ?? []; // [pergunta_id => 'conforme'|'nao_conforme']
  $obs    = $_POST['observacao'] ?? []; // [pergunta_id => 'texto']

  foreach ($resps as $pid => $val) {
    $pid = (int)$pid;
    if (!$pid) continue;
    $val = ($val === 'conforme') ? 'conforme' : (($val === 'nao_conforme') ? 'nao_conforme' : null);
    $textoObs = trim((string)($obs[$pid] ?? ''));

    // upsert simples: tenta update, se 0 rows -> insert
    $up = $pdo->prepare("UPDATE respostas SET resposta=?, observacao=? WHERE execucao_id=? AND pergunta_id=?");
    $up->execute([$val, $textoObs !== '' ? $textoObs : null, $execId, $pid]);
    if ($up->rowCount() === 0) {
      $ins = $pdo->prepare("INSERT INTO respostas (execucao_id, pergunta_id, resposta, observacao) VALUES (?, ?, ?, ?)");
      $ins->execute([$execId, $pid, $val, $textoObs !== '' ? $textoObs : null]);
    }
  }
  $okMsg = 'Respostas salvas.';
}

// carrega perguntas do checklist dessa execução, somente as atribuídas ao colaborador (se houver colaborador_id)
if ($colaboradorId > 0) {
  $q = $pdo->prepare("
    SELECT p.id, p.texto, p.peso, g.nome AS gerencia, s.nome AS setor
      FROM checklist_perguntas p
      JOIN gerencias g ON g.id = p.gerencia_id
      JOIN setores   s ON s.id = p.setor_id
      JOIN checklist_pergunta_responsaveis r ON r.pergunta_id = p.id
     WHERE p.checklist_id = ?
       AND r.colaborador_id = ?
     ORDER BY g.nome, s.nome, p.ordem, p.id
  ");
  $q->execute([(int)$exec['checklist_id'], $colaboradorId]);
} else {
  // fallback: sem colaborador vinculado, mostra todas (não é o ideal)
  $q = $pdo->prepare("
    SELECT p.id, p.texto, p.peso, g.nome AS gerencia, s.nome AS setor
      FROM checklist_perguntas p
      JOIN gerencias g ON g.id = p.gerencia_id
      JOIN setores   s ON s.id = p.setor_id
     WHERE p.checklist_id = ?
     ORDER BY g.nome, s.nome, p.ordem, p.id
  ");
  $q->execute([(int)$exec['checklist_id']]);
}
$perguntas = $q->fetchAll(PDO::FETCH_ASSOC);

// carrega respostas já existentes desta execução
$respMap = [];
if ($perguntas) {
  $ids = array_column($perguntas, 'id');
  $in  = implode(',', array_fill(0, count($ids), '?'));
  $qr  = $pdo->prepare("SELECT pergunta_id, resposta, observacao FROM respostas WHERE execucao_id=? AND pergunta_id IN ($in)");
  $bind = array_merge([$execId], $ids);
  $qr->execute($bind);
  foreach ($qr->fetchAll(PDO::FETCH_ASSOC) as $r) {
    $respMap[(int)$r['pergunta_id']] = $r;
  }
}

include __DIR__ . '/../../app/partials/head.php';
include __DIR__ . '/../../app/partials/topbar.php';
?>
<div class="container mt-4">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h1 class="h4 m-0">Responder: <?= e($exec['titulo']) ?> <small class="text-muted">(#<?= (int)$exec['id'] ?>)</small></h1>
    <div class="d-flex gap-2">
      <a class="btn btn-outline-secondary" href="<?= e(url('empresa_user/index.php')) ?>">Voltar</a>
      <form method="post" action="<?= e(url('execucoes/finalizar.php?id='.(int)$exec['id'])) ?>" onsubmit="return confirm('Finalizar esta execução?');">
        <button class="btn btn-success">Finalizar</button>
      </form>
    </div>
  </div>

  <?php if ($okMsg): ?><div class="alert alert-success"><?= e($okMsg) ?></div><?php endif; ?>
  <?php if ($errors): ?>
    <div class="alert alert-danger"><strong>Não foi possível salvar:</strong><br><?= implode('<br>', array_map('e',$errors)) ?></div>
  <?php endif; ?>

  <?php if (!$perguntas): ?>
    <div class="alert alert-info">Nenhuma pergunta atribuída para você neste checklist.</div>
  <?php else: ?>
    <form method="post">
      <input type="hidden" name="salvar" value="1">
      <?php
        // agrupar por gerencia/setor
        $grp = [];
        foreach ($perguntas as $p) $grp[$p['gerencia']][$p['setor']][] = $p;
      ?>
      <?php foreach ($grp as $ger => $bySetor): ?>
        <div class="card mb-3">
          <div class="card-header bg-dark text-white fw-bold">Gerência: <?= e($ger ?: '—') ?></div>
          <div class="card-body">
            <?php foreach ($bySetor as $set => $list): ?>
              <div class="mb-2 p-2 rounded" style="background:#f8f9fa;border:1px solid #eee;">
                <div class="fw-bold mb-2">Setor: <?= e($set ?: '—') ?></div>
                <?php foreach ($list as $p): 
                  $r = $respMap[(int)$p['id']] ?? null;
                  $val = $r['resposta'] ?? '';
                  $obs = $r['observacao'] ?? '';
                ?>
                  <div class="mb-3">
                    <div class="mb-1"><strong>#<?= (int)$p['id'] ?></strong> — <?= nl2br(e($p['texto'])) ?></div>
                    <div class="d-flex align-items-center gap-3">
                      <label class="form-check">
                        <input class="form-check-input" type="radio" name="resposta[<?= (int)$p['id'] ?>]" value="conforme"     <?= $val==='conforme'?'checked':'' ?>>
                        <span class="form-check-label">Conforme</span>
                      </label>
                      <label class="form-check">
                        <input class="form-check-input" type="radio" name="resposta[<?= (int)$p['id'] ?>]" value="nao_conforme" <?= $val==='nao_conforme'?'checked':'' ?>>
                        <span class="form-check-label">Não conforme</span>
                      </label>
                    </div>
                    <div class="mt-2">
                      <textarea name="observacao[<?= (int)$p['id'] ?>]" class="form-control" rows="2" placeholder="Observações (opcional)"><?= e($obs) ?></textarea>
                    </div>
                  </div>
                <?php endforeach; ?>
              </div>
            <?php endforeach; ?>
          </div>
        </div>
      <?php endforeach; ?>

      <div class="d-grid d-md-flex gap-2">
        <button class="btn btn-primary">Salvar respostas</button>
        <a class="btn btn-outline-secondary" href="<?= e(url('empresa_user/index.php')) ?>">Sair sem finalizar</a>
      </div>
    </form>
  <?php endif; ?>
</div>
<?php include __DIR__ . '/../../app/partials/foot.php'; ?>
