<?php
// public/login.php
require_once __DIR__ . '/../app/core/auth.php';
require_once __DIR__ . '/../app/core/helpers.php'; // para e()

$pageTitle = 'Login';

$erro = null;
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $email = $_POST['email'] ?? '';
  $senha = $_POST['senha'] ?? '';
  if (login($email, $senha)) {
    $u = current_user();
    switch ($u['role'] ?? '') {
      case 'admin':        redirect('index.php'); break;
      case 'gerente':      redirect('painel/gerente.php'); break;
      case 'empresa_user': redirect('empresa_user/index.php'); break;
      case 'diretor':      redirect('painel/diretor.php'); break;
      default:             redirect('index.php'); break;
    }
  } else {
    $erro = "E-mail ou senha inválidos.";
  }
}

include __DIR__ . '/../app/partials/head.php';
?>

<style>
  /* Fundo com gradiente e padrões suaves */
  .auth-bg {
    min-height: 100vh;
    background:
      radial-gradient(1200px 600px at 80% -10%, rgba(14, 124, 133, .18), transparent 60%),
      radial-gradient(900px 500px at -10% 100%, rgba(241, 169, 131, .16), transparent 60%),
      linear-gradient(180deg, var(--bs-body-bg), var(--bs-body-bg));
    display: grid;
    place-items: center;
    padding: 24px;
  }

  /* Card com efeito “glass” */
  .auth-card {
    width: 100%;
    max-width: 410px;
    border: 1px solid rgba(0,0,0,.06);
    backdrop-filter: saturate(1.2) blur(6px);
    -webkit-backdrop-filter: saturate(1.2) blur(6px);
    border-radius: 18px;
    box-shadow: 0 10px 30px rgba(0,0,0,.08);
  }

  .brand-badge {
    width: 60px; height: 60px;
    display: grid; place-items: center;
    border-radius: 16px;
    background: linear-gradient(135deg, #0e7c85, #0b3040);
    color: #fff; font-weight: 700; font-size: 18px;
    box-shadow: 0 6px 18px rgba(14,124,133,.3);
  }

  .input-icon {
    position: absolute; left: 12px; top: 73%; transform: translateY(-50%);
    opacity: .5;
  }
  .form-control.ps-5 { padding-left: 2.6rem !important; }

  .toggle-pass {
    position: absolute; right: 8px; top: 73%; transform: translateY(-50%);
    border: 0; background: transparent; padding: 6px; opacity: .6;
  }
  .toggle-pass:hover { opacity: .9; }

  .fine-text { font-size: .9rem; opacity: .8; }

  @media (prefers-color-scheme: dark) {
    .auth-card { border-color: rgba(255,255,255,.08); }
  }
</style>

<main class="auth-bg">
  <div class="card auth-card">
    <div class="card-body p-4 p-md-5">
      <div class="d-flex align-items-center gap-3 mb-3">
        <div class="brand-badge">GM</div>
        <div>
          <h1 class="h4 mb-0">Bem-vindo de volta</h1>
          <div class="text-muted fine-text">Acesse sua conta para continuar</div>
        </div>
      </div>

      <?php if(!empty($erro)): ?>
        <div class="alert alert-danger d-flex align-items-start gap-2">
          <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" fill="currentColor" class="bi bi-x-octagon mt-1" viewBox="0 0 16 16">
            <path d="M11.46.146A.5.5 0 0 1 11.814 0h2.672a.5.5 0 0 1 .353.146l1.015 1.015A.5.5 0 0 1 16 1.514v2.672a.5.5 0 0 1-.146.353l-1.015 1.015a.5.5 0 0 1-.353.146h-2.672a.5.5 0 0 1-.353-.146L10.447 4.54a.5.5 0 0 1-.146-.353V1.514a.5.5 0 0 1 .146-.353L11.46.146z"/>
            <path d="M4.54 10.447a.5.5 0 0 1 .146.353v2.672a.5.5 0 0 1-.146.353L3.525 15.04a.5.5 0 0 1-.353.146H.5a.5.5 0 0 1-.353-.146L.146 14.025A.5.5 0 0 1 0 13.672V11a.5.5 0 0 1 .146-.353l1.015-1.015A.5.5 0 0 1 1.514 9.5h2.672a.5.5 0 0 1 .353.146l.001.001z"/>
            <path d="M6.146 6.146a.5.5 0 1 1 .708.708L5.707 8l1.147 1.146a.5.5 0 0 1-.708.708L5 8.707l-1.146 1.147a.5.5 0 0 1-.708-.708L4.293 8 3.146 6.854a.5.5 0 1 1 .708-.708L5 7.293z"/>
          </svg>
          <div><?= e($erro) ?></div>
        </div>
      <?php endif; ?>

      <form method="post" id="loginForm" novalidate>
        <!-- Email -->
        <div class="mb-3 position-relative">
          <label class="form-label" for="email">E-mail</label>
          <svg class="input-icon" xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24"><path fill="currentColor" d="M20 4H4a2 2 0 0 0-2 2v.01L12 13l10-6.99V6a2 2 0 0 0-2-2m0 4.5L12 15L4 8.5V18a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2z"/></svg>
          <input type="email" class="form-control ps-5" id="email" name="email" placeholder="seu@email.com" required autofocus>
        </div>

        <!-- Senha -->
        <div class="mb-2 position-relative">
          <label class="form-label" for="senha">Senha</label>
          <svg class="input-icon" xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24"><path fill="currentColor" d="M12 17a2 2 0 1 0 0-4a2 2 0 0 0 0 4m6-6h-1V9a5 5 0 1 0-10 0v2H6a2 2 0 0 0-2 2v7a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2v-7a2 2 0 0 0-2-2M9 9a3 3 0 1 1 6 0v2H9z"/></svg>
          <input type="password" class="form-control ps-5" id="senha" name="senha" placeholder="••••••" minlength="6" required>
          <button class="toggle-pass" type="button" aria-label="Mostrar senha" tabindex="-1">
            <svg id="eyeOpen" xmlns="http://www.w3.org/2000/svg" width="18" height="18" style="display:block" viewBox="0 0 24 24"><path fill="currentColor" d="M12 7c5 0 9 5 9 5s-4 5-9 5s-9-5-9-5s4-5 9-5m0 2a3 3 0 0 0 0 6a3 3 0 0 0 0-6"/></svg>
            <svg id="eyeClosed" xmlns="http://www.w3.org/2000/svg" width="18" height="18" style="display:none" viewBox="0 0 24 24"><path fill="currentColor" d="M2 5.27L3.28 4L20 20.72L18.73 22l-2.82-2.82A10.85 10.85 0 0 1 12 20c-5 0-9-5-9-5a17.06 17.06 0 0 1 4.18-3.73L2 5.27M12 7a10.85 10.85 0 0 1 6.54 2.18l-1.47 1.47A8.86 8.86 0 0 0 12 9a3 3 0 0 0-3 3a2.86 2.86 0 0 0 .12.83l-1.76-1.76A5.1 5.1 0 0 1 7 12a5 5 0 0 1 5-5m0 10a5 5 0 0 1-5-5l-1.5-1.5A14.76 14.76 0 0 0 3 12s4 5 9 5a14.76 14.76 0 0 0 2.5-.25L12.73 15A3 3 0 0 1 12 17"/></svg>
          </button>
        </div>

        <div class="d-flex justify-content-between align-items-center mb-4">
          <div class="form-check">
            <input class="form-check-input" type="checkbox" value="1" id="lembrar">
            <label class="form-check-label fine-text" for="lembrar">Manter conectado</label>
          </div>
          <a class="fine-text text-decoration-none" href="#" onclick="event.preventDefault()">Esqueci minha senha</a>
        </div>

        <button class="btn btn-primary w-100 d-inline-flex align-items-center justify-content-center gap-2" id="btnEntrar">
          <span class="spinner-border spinner-border-sm me-1 d-none" role="status" aria-hidden="true"></span>
          Entrar
        </button>
      </form>
    </div>
    <div class="card-footer text-center py-3">
      <small class="text-muted">© <?= date('Y') ?> Geomark — Todos os direitos reservados</small>
    </div>
  </div>
</main>

<script>
  // Mostrar/ocultar senha
  (function(){
    const input = document.getElementById('senha');
    const btn = document.querySelector('.toggle-pass');
    const eyeOpen = document.getElementById('eyeOpen');
    const eyeClosed = document.getElementById('eyeClosed');
    if (!input || !btn) return;
    btn.addEventListener('click', function(){
      const isPass = input.getAttribute('type') === 'password';
      input.setAttribute('type', isPass ? 'text' : 'password');
      eyeOpen.style.display = isPass ? 'none' : 'block';
      eyeClosed.style.display = isPass ? 'block' : 'none';
    });
  })();

  // Spinner no botão e disable durante submit
  (function(){
    const form = document.getElementById('loginForm');
    const btn  = document.getElementById('btnEntrar');
    if (!form || !btn) return;
    form.addEventListener('submit', function(){
      const spn = btn.querySelector('.spinner-border');
      spn && spn.classList.remove('d-none');
      btn.setAttribute('disabled', 'disabled');
    });
  })();
</script>

<?php include __DIR__ . '/../app/partials/foot.php'; ?>
